/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http;

import io.enoa.chunk.Chunk;
import io.enoa.http.EoEmit;
import io.enoa.http.EoExecutor;
import io.enoa.http.EoHttp;
import io.enoa.http.EoHttpConfig;
import io.enoa.http.EoUrl;
import io.enoa.http.HttpAuth;
import io.enoa.http.protocol.HttpHeader;
import io.enoa.http.protocol.HttpMethod;
import io.enoa.http.protocol.HttpPara;
import io.enoa.http.protocol.HttpPromise;
import io.enoa.http.protocol.enoa.IHttpHandler;
import io.enoa.http.protocol.enoa.IHttpReporter;
import io.enoa.http.proxy.HttpProxy;
import io.enoa.http.proxy.TcpProxy;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;

public interface Http
extends EoEmit {
    public static Http use(EoHttp http) {
        return http.http();
    }

    public static Http use() {
        return Http.use(EoHttp.def());
    }

    public static Http request() {
        return Http.use();
    }

    public static Http request(String url) {
        return Http.request(EoUrl.with(url));
    }

    public static Http request(HttpMethod method, String url) {
        return Http.request(method, EoUrl.with(url));
    }

    public static Http request(EoUrl url) {
        return Http.request().url(url);
    }

    public static Http request(HttpMethod method, EoUrl url) {
        return Http.request().method(method).url(url);
    }

    public Http executor(EoExecutor var1);

    public HttpPromise enqueue();

    public HttpPromise enqueue(Chunk var1);

    public Http handler(IHttpHandler var1);

    public Http reporter(IHttpReporter var1);

    public Http method(HttpMethod var1);

    public Http config(EoHttpConfig var1);

    public Http charset(Charset var1);

    default public Http url(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        return this.url(EoUrl.with(url));
    }

    public Http url(EoUrl var1);

    default public Http traditional() {
        return this.traditional(true);
    }

    public Http traditional(boolean var1);

    default public Http encode() {
        return this.encode(true);
    }

    public Http encode(boolean var1);

    public Http para(String var1, Object var2);

    public Http para(String var1, Object ... var2);

    public Http para(String var1, Collection var2);

    public Http para(String var1, Path var2);

    public Http para(String var1, String var2, byte[] var3);

    default public Http para(HttpPara para) {
        return this.para(para.name(), (Object)para.value());
    }

    default public Http para(HttpPara ... paras) {
        if (paras == null) {
            throw new IllegalArgumentException("paras == null");
        }
        for (HttpPara para : paras) {
            this.para(para.name(), (Object)para.value());
        }
        return this;
    }

    default public Http para(Collection<HttpPara> paras) {
        if (paras == null) {
            throw new IllegalArgumentException("paras == null");
        }
        paras.forEach(para -> this.para(para.name(), (Object)para.value()));
        return this;
    }

    public Http para(Path var1);

    default public Http raw(String raw) {
        return this.raw(raw, null);
    }

    public Http raw(String var1, String var2);

    default public Http header(String name, String value) {
        this.header(new HttpHeader(name, value));
        return this;
    }

    public Http header(HttpHeader var1);

    default public Http header(HttpHeader[] headers) {
        if (headers == null) {
            throw new IllegalArgumentException("headers == null");
        }
        for (HttpHeader header : headers) {
            this.header(header);
        }
        return this;
    }

    default public Http header(Collection<HttpHeader> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("headers == null");
        }
        headers.forEach(this::header);
        return this;
    }

    public Http cookie(String var1, String var2);

    public Http contentType(String var1);

    public Http proxy(HttpProxy var1);

    default public Http proxy(String host, int port) {
        return this.proxy(host, port, null, null);
    }

    default public Http proxy(String host, int port, String user) {
        return this.proxy(host, port, user, null);
    }

    default public Http proxy(String host, int port, String user, String passwd) {
        return this.proxy(new TcpProxy(host, port, user, passwd));
    }

    public Http auth(HttpAuth var1);

    public Http binary(byte[] var1);

    default public Http binary(ByteBuffer binary) {
        if (binary == null) {
            throw new IllegalArgumentException("binary == null");
        }
        return this.binary(binary.array());
    }
}

