/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.promise.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EPXEnoaPromiseExecutorBuilder {
    private EPXEnoaPromiseExecutorBuilder() {
    }

    static EPXEnoaPromiseExecutorBuilder instance() {
        return Holder.INSTANCE;
    }

    public ExecutorService enqueue(String name) {
        return this.single(name);
    }

    public ExecutorService enqueue(String name, boolean daemon) {
        return this.single(name, daemon);
    }

    public ExecutorService single(String name) {
        return this.single(name, Boolean.FALSE);
    }

    public ExecutorService single(String name, boolean daemon) {
        return Executors.newSingleThreadExecutor(runnable -> {
            Thread result = new Thread(runnable, name);
            result.setDaemon(daemon);
            return result;
        });
    }

    public ExecutorService multiple(String name) {
        return this.multiple(name, Boolean.FALSE);
    }

    public ExecutorService multiple(String name, boolean daemon) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), runnable -> {
            Thread result = new Thread(runnable, name);
            result.setDaemon(daemon);
            return result;
        });
    }

    private static class Holder {
        private static final EPXEnoaPromiseExecutorBuilder INSTANCE = new EPXEnoaPromiseExecutorBuilder();

        private Holder() {
        }
    }
}

