/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.provider.httphelper.conn;

import io.enoa.chunk.Chunk;
import io.enoa.http.protocol.HttpHeader;
import io.enoa.http.protocol.HttpResponse;
import io.enoa.http.provider.httphelper.HttpHelperConfig;
import io.enoa.http.provider.httphelper.conn.ssl._HttpHelperSSL;
import io.enoa.http.provider.httphelper.http.req._HttpHelperRequest;
import io.enoa.http.provider.httphelper.http.resp._HttpHelperChunkedResponse;
import io.enoa.http.provider.httphelper.http.resp._HttpHelperResponse;
import io.enoa.http.proxy.HttpProxy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class _HttpHelperConn {
    private _HttpHelperRequest request;
    private HttpHelperConfig config;

    public _HttpHelperConn(HttpHelperConfig config, _HttpHelperRequest request) {
        this.config = config;
        this.request = request;
    }

    private HttpURLConnection connection() throws IOException {
        HttpURLConnection conn;
        HttpProxy httpProxy = this.request.proxy();
        Proxy proxy = null;
        if (httpProxy != null) {
            proxy = this.request.proxy().proxy();
        }
        URL _url = new URL(this.request.url());
        HttpURLConnection httpURLConnection = conn = proxy == null ? (HttpURLConnection)_url.openConnection() : (HttpURLConnection)_url.openConnection(proxy);
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(_HttpHelperSSL.sslSocket());
            ((HttpsURLConnection)conn).setHostnameVerifier(_HttpHelperSSL.hostnameVerifier());
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(this.request.config().connectionTimeout());
        conn.setReadTimeout(this.request.config().soTimeout());
        try {
            conn.setRequestMethod(this.request.method().name());
        }
        catch (Exception e) {
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-HTTP-Method-Override", this.request.method().name());
        }
        Set<HttpHeader> headers = this.request.headers();
        if (headers == null || headers.isEmpty()) {
            return conn;
        }
        headers.forEach(header -> conn.setRequestProperty(header.name(), header.value()));
        return conn;
    }

    private InputStream inputstream(HttpURLConnection conn) {
        OutputStream os = null;
        InputStream inputStream = null;
        try {
            int responseCode;
            conn.connect();
            if (this.request.body() != null) {
                os = conn.getOutputStream();
                os.write(this.request.body().bytes());
                os.flush();
                os.close();
            }
            InputStream inputStream2 = inputStream = (responseCode = conn.getResponseCode()) >= 400 ? conn.getErrorStream() : conn.getInputStream();
            return inputStream2;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ConnectException) {
                throw new RuntimeException(e.getMessage() + " => " + this.request.url());
            }
            if (e.getCause() instanceof FileNotFoundException) {
                throw new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse execute() {
        HttpURLConnection conn;
        try {
            conn = this.connection();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try (InputStream inputstream = this.inputstream(conn);){
            _HttpHelperResponse _HttpHelperResponse2 = new _HttpHelperResponse(this.config, conn, inputstream, this.request.charset());
            return _HttpHelperResponse2;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse chunked(Chunk chunk) {
        HttpURLConnection conn;
        try {
            conn = this.connection();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try (InputStream inputstream = this.inputstream(conn);){
            _HttpHelperChunkedResponse _HttpHelperChunkedResponse2 = new _HttpHelperChunkedResponse(this.config, conn, inputstream, this.request.charset(), chunk);
            return _HttpHelperChunkedResponse2;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

