/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

import java.io.IOException;

public enum HttpVersion {
    HTTP_1_0("http/1.0"),
    HTTP_1_1("http/1.1"),
    SPDY_3("spdy/3.1"),
    HTTP_2("h2");

    private final String version;

    private HttpVersion(String version) {
        this.version = version;
    }

    public static HttpVersion of(String version) throws IOException {
        if (version.equalsIgnoreCase(HttpVersion.HTTP_1_0.version)) {
            return HTTP_1_0;
        }
        if (version.equalsIgnoreCase(HttpVersion.HTTP_1_1.version)) {
            return HTTP_1_1;
        }
        if (version.equalsIgnoreCase(HttpVersion.HTTP_2.version)) {
            return HTTP_2;
        }
        if (version.equalsIgnoreCase(HttpVersion.SPDY_3.version)) {
            return SPDY_3;
        }
        throw new IOException("Unexpected http version: " + version);
    }

    public String toString() {
        return this.version;
    }
}

