/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HttpHeader {
    private final String name;
    private final String value;

    public HttpHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name can not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Header value con not be null.");
        }
        this.name = name;
        this.value = value;
    }

    public static Set<HttpHeader> of(String text) {
        if (text == null || "".equals(text)) {
            return Collections.emptySet();
        }
        String[] lines = text.split("\n");
        HashSet<HttpHeader> headers = new HashSet<HttpHeader>(lines.length);
        for (String line : lines) {
            String value;
            String name;
            int qix = line.indexOf(":");
            int eix = line.indexOf("=");
            if (qix == -1 && eix == -1) continue;
            if (qix != -1) {
                name = line.substring(0, qix);
                value = line.substring(qix + 1);
            } else {
                name = line.substring(0, eix);
                value = line.substring(eix + 1);
            }
            headers.add(new HttpHeader(name, value));
        }
        return headers;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.toLowerCase().hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpHeader)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HttpHeader header = (HttpHeader)obj;
        return this.name.equalsIgnoreCase(header.name) && this.value.equals(header.value);
    }

    public String toString() {
        return this.name.concat(": ").concat(this.value);
    }
}

