/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

import java.nio.file.Path;

public class HttpFormData {
    private final byte[] EMPTY_BINARY = new byte[0];
    private final String name;
    private final String text;
    private final Path file;
    private final String filename;
    private final byte[] binary;
    private final Type type;

    public HttpFormData(String name, String text) {
        this.name = name;
        this.text = text;
        this.type = Type.TEXT;
        this.file = null;
        this.filename = null;
        this.binary = this.EMPTY_BINARY;
    }

    public HttpFormData(String name, Path file) {
        this.name = name;
        this.file = file;
        this.type = Type.FILE;
        this.text = null;
        this.filename = null;
        this.binary = this.EMPTY_BINARY;
    }

    public HttpFormData(String name, String filename, byte[] binary) {
        this.name = name;
        this.filename = filename;
        this.binary = binary;
        this.type = Type.BINARY;
        this.text = null;
        this.file = null;
    }

    public String name() {
        return this.name;
    }

    public String text() {
        return this.text;
    }

    public Path file() {
        return this.file;
    }

    public Type type() {
        return this.type;
    }

    public String filename() {
        return this.filename;
    }

    public byte[] binary() {
        return this.binary;
    }

    public String toString() {
        return "HttpFormData{name='" + this.name + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + (this.text == null ? "" : ", text='" + this.text + '\'') + (this.file == null ? "" : ", file=" + this.file) + '}';
    }

    public static enum Type {
        TEXT,
        FILE,
        BINARY;

    }
}

