/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

import io.enoa.http.protocol.HttpDate;
import java.net.IDN;
import java.util.Date;
import java.util.Locale;

public class HttpCookie {
    private final String name;
    private final String value;
    private final long expires;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private HttpCookie(String name, String value, long expires, String domain, String path, boolean secure, boolean httpOnly, boolean hostOnly, boolean persistent) {
        this.name = name;
        this.value = value;
        this.expires = expires;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.hostOnly = hostOnly;
        this.persistent = persistent;
    }

    HttpCookie(Builder builder) {
        if (builder.name == null) {
            throw new NullPointerException("builder.name == null");
        }
        if (builder.value == null) {
            throw new NullPointerException("builder.value == null");
        }
        this.name = builder.name;
        this.value = builder.value;
        this.expires = builder.expiresAt;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.persistent = builder.persistent;
        this.hostOnly = builder.hostOnly;
    }

    public static HttpCookie single(String text) {
        if (text == null || "".equals(text)) {
            return null;
        }
        String[] items = text.split(";");
        Builder builder = new Builder();
        block16: for (String item : items) {
            int eix = item.indexOf("=");
            String name = eix > -1 ? item.substring(0, eix).trim() : item.trim();
            String value = null;
            if (eix > -1) {
                value = item.substring(eix + 1).trim();
            }
            switch (name.toLowerCase()) {
                case "max-age": {
                    builder.expires(0L);
                    continue block16;
                }
                case "expires": {
                    continue block16;
                }
                case "domain": {
                    if (value == null) continue block16;
                    builder.domain(value);
                    continue block16;
                }
                case "path": {
                    if (value == null) continue block16;
                    builder.path(value);
                    continue block16;
                }
                case "secure": {
                    builder.secure();
                    continue block16;
                }
                case "httponly": {
                    builder.httpOnly();
                    continue block16;
                }
                default: {
                    if (value == null) continue block16;
                    builder.name(name);
                    builder.value(value);
                }
            }
        }
        return builder.build();
    }

    public static Builder builder(String name, String value) {
        return new Builder().name(name).value(value);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public long expires() {
        return this.expires;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean forObsoleteRfc2965) {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        result.append('=');
        result.append(this.value);
        if (this.persistent) {
            if (this.expires == Long.MIN_VALUE) {
                result.append("; max-age=0");
            } else {
                result.append("; expires=").append(HttpDate.format(new Date(this.expires)));
            }
        }
        if (!this.hostOnly && this.domain != null) {
            result.append("; domain=");
            if (forObsoleteRfc2965) {
                result.append(".");
            }
            result.append(this.domain);
        }
        result.append("; path=").append(this.path);
        if (this.secure) {
            result.append("; secure");
        }
        if (this.httpOnly) {
            result.append("; httponly");
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof HttpCookie)) {
            return false;
        }
        HttpCookie that = (HttpCookie)other;
        return that.name.equals(this.name) && that.value.equals(this.value) && that.domain != null && this.domain != null ? that.domain.equals(this.domain) : (that.domain == null && this.domain == null && that.path != null && this.path != null ? that.path.equals(this.path) : that.path == null && this.path == null && that.expires == this.expires && that.secure == this.secure && that.httpOnly == this.httpOnly && that.persistent == this.persistent && that.hostOnly == this.hostOnly);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + this.value.hashCode();
        hash = 31 * hash + (this.domain == null ? 0 : this.domain.hashCode());
        hash = 31 * hash + (this.path == null ? 0 : this.path.hashCode());
        hash = 31 * hash + (int)(this.expires ^ this.expires >>> 32);
        hash = 31 * hash + (this.secure ? 0 : 1);
        hash = 31 * hash + (this.httpOnly ? 0 : 1);
        hash = 31 * hash + (this.persistent ? 0 : 1);
        hash = 31 * hash + (this.hostOnly ? 0 : 1);
        return hash;
    }

    public static final class Builder {
        String name;
        String value;
        long expiresAt = 253402300799999L;
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;

        private static String domainToAscii(String input) {
            try {
                String result;
                boolean dotfirst;
                boolean bl = dotfirst = input.charAt(0) == '.';
                if (input.charAt(0) == '.') {
                    input = input.substring(1);
                }
                if ((result = IDN.toASCII(input).toLowerCase(Locale.US)).isEmpty()) {
                    return null;
                }
                if (dotfirst) {
                    result = '.' + result;
                }
                if (Builder.containsInvalidHostnameAsciiCodes(result)) {
                    return null;
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private static boolean containsInvalidHostnameAsciiCodes(String hostnameAscii) {
            for (int i = 0; i < hostnameAscii.length(); ++i) {
                char c = hostnameAscii.charAt(i);
                if (c <= '\u001f' || c >= '\u007f') {
                    return true;
                }
                if (" #%/:?@[\\]".indexOf(c) == -1) continue;
                return true;
            }
            return false;
        }

        public Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (!name.trim().equals(name)) {
                throw new IllegalArgumentException("name is not trimmed");
            }
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            if (value == null) {
                throw new NullPointerException("value == null");
            }
            if (!value.trim().equals(value)) {
                throw new IllegalArgumentException("value is not trimmed");
            }
            this.value = value;
            return this;
        }

        public Builder expires(long expiresAt) {
            if (expiresAt <= 0L) {
                expiresAt = Long.MIN_VALUE;
            }
            if (expiresAt > 253402300799999L) {
                expiresAt = 253402300799999L;
            }
            this.expiresAt = expiresAt;
            this.persistent = true;
            return this;
        }

        public Builder domain(String domain) {
            return this.domain(domain, false);
        }

        public Builder hostOnlyDomain(String domain) {
            return this.domain(domain, true);
        }

        private Builder domain(String domain, boolean hostOnly) {
            if (domain == null) {
                throw new NullPointerException("domain == null");
            }
            String canonicalDomain = Builder.domainToAscii(domain);
            if (canonicalDomain == null) {
                throw new IllegalArgumentException("unexpected domain: " + domain);
            }
            this.domain = canonicalDomain;
            this.hostOnly = hostOnly;
            return this;
        }

        public Builder path(String path) {
            if (path != null && !path.startsWith("/")) {
                throw new IllegalArgumentException("path must start with '/'");
            }
            this.path = path;
            return this;
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public HttpCookie build() {
            return new HttpCookie(this);
        }
    }
}

