/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.chunk;

import io.enoa.chunk.Chunk;
import java.io.ByteArrayOutputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChunkCaller {
    private Chunk chunk;
    private ExecutorService executor;
    private Queue<Byte> queues;
    private AtomicBoolean finish;
    private volatile boolean changed;

    ChunkCaller(Chunk chunk) {
        this.chunk = chunk;
        this.changed = false;
        this.queues = new ConcurrentLinkedDeque<Byte>();
        this.finish = new AtomicBoolean(Boolean.FALSE);
        this.executor = Executors.newSingleThreadExecutor();
        this.listen();
    }

    public void destroy() {
        this.destroy(Boolean.FALSE);
    }

    void destroy(boolean await) {
        if (await && !this.queues.isEmpty()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.finish.set(Boolean.TRUE);
    }

    public void call(byte[] bytes) {
        for (byte b : bytes) {
            this.queues.offer(b);
        }
    }

    private void threadname(Thread thread) {
        String oldname = thread.getName();
        int fix = oldname.indexOf("-");
        int lix = oldname.lastIndexOf("-");
        String group = oldname.substring(fix + 1, lix);
        thread.setName(this.chunk + "-" + group);
    }

    private void listen() {
        this.executor.execute(() -> {
            this.threadname(Thread.currentThread());
            try (ByteArrayOutputStream temp = new ByteArrayOutputStream();){
                boolean precr = false;
                while (true) {
                    boolean empty = this.queues.isEmpty();
                    if (this.chunk.stopper().stop() || this.finish.get() && this.queues.isEmpty()) break;
                    if (empty) {
                        this.changed = false;
                        continue;
                    }
                    Byte b = this.queues.poll();
                    if (b == 13 || b == 10) {
                        if (b == 13) {
                            precr = true;
                            continue;
                        }
                        this.call(temp, precr ? "\r\n" : String.valueOf(b));
                        if (!precr) continue;
                        precr = false;
                        continue;
                    }
                    if (precr) {
                        this.call(temp, "\r");
                        precr = false;
                    }
                    temp.write(b.byteValue());
                    this.changed = true;
                }
                try {
                    this.call(temp, "\n");
                    this.executor.shutdown();
                    this.queues.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void call(ByteArrayOutputStream temp, String linebreak) {
        boolean empty;
        byte[] bytes = temp.toByteArray();
        boolean bl = empty = bytes.length == 0;
        if (empty && !this.changed) {
            return;
        }
        this.chunk.runner().run(bytes, linebreak);
        temp.reset();
    }
}

