/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.proxy;

import io.enoa.http.proxy.HttpProxy;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class SocketProxy
implements HttpProxy {
    private String host;
    private Integer port;

    public SocketProxy(String host, Integer port) {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("Host can not be null");
        }
        if (port == null) {
            throw new IllegalArgumentException("Port can not be null");
        }
        this.host = host;
        this.port = port;
    }

    @Override
    public Proxy proxy() {
        InetSocketAddress addr = new InetSocketAddress(this.host, (int)this.port);
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
        return proxy;
    }

    public String toString() {
        return "SocketProxy{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

