/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.provider.httphelper;

import io.enoa.http.EoHttpConfig;

public class HttpHelperConfig
implements EoHttpConfig {
    private final int connectionTimeout;
    private final int soTimeout;
    private final boolean debug;

    private HttpHelperConfig(Builder builder) {
        this.connectionTimeout = builder.connectionTimeout;
        this.soTimeout = builder.soTimeout;
        this.debug = builder.debug;
    }

    public HttpHelperConfig(EoHttpConfig config) {
        this(new Builder(config));
    }

    @Override
    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public int soTimeout() {
        return this.soTimeout;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    public static class Builder {
        private int connectionTimeout = 20000;
        private int soTimeout = 30000;
        private boolean debug = Boolean.FALSE;

        public Builder() {
        }

        private Builder(EoHttpConfig config) {
            this();
            this.connectionTimeout = config.connectionTimeout();
            this.soTimeout = config.soTimeout();
        }

        public HttpHelperConfig build() {
            return new HttpHelperConfig(this);
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder debug() {
            return this.debug(Boolean.TRUE);
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }
    }
}

