/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

import java.nio.charset.Charset;

public abstract class HttpResponseBody {
    public abstract Charset charset();

    public abstract byte[] bytes();

    public String string() {
        return this.string(this.charset());
    }

    public String string(Charset charset) {
        return new String(this.bytes(), charset);
    }

    public static HttpResponseBody create(final byte[] bytes, final Charset charset) {
        return new HttpResponseBody(){

            @Override
            public Charset charset() {
                return charset;
            }

            @Override
            public byte[] bytes() {
                return bytes;
            }
        };
    }

    public static HttpResponseBody create(final String body, final Charset charset) {
        return new HttpResponseBody(){

            @Override
            public Charset charset() {
                return charset;
            }

            @Override
            public byte[] bytes() {
                return body.getBytes(charset);
            }
        };
    }

    public String toString() {
        String show;
        try {
            show = this.string();
        }
        catch (Exception e) {
            show = String.format("null (ERROR : %s)", e.getMessage());
        }
        return show.length() > 3000 ? show.substring(0, 3000).concat("\n...") : show;
    }
}

