/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.protocol;

public class HttpHeader {
    private final String name;
    private final String value;

    public HttpHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name can not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Header value con not be null.");
        }
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.toLowerCase().hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpHeader)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        HttpHeader header = (HttpHeader)obj;
        return this.name.equalsIgnoreCase(header.name) && this.value.equals(header.value);
    }

    public String toString() {
        return this.name.concat(": ").concat(this.value);
    }
}

