/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.http.auth.basic;

import io.enoa.http.HttpAuth;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;

public class BasicAuth
implements HttpAuth {
    private static Boolean HIGHT;
    private String user;
    private String passwd;
    private String token;

    public BasicAuth(String user, String passwd) {
        if (user == null) {
            throw new IllegalArgumentException("Basic auth user can not be null.");
        }
        if (passwd == null) {
            throw new IllegalArgumentException("Basic auth passwd can not be null.");
        }
        this.user = user;
        this.passwd = passwd;
        this.token = this.encode(user, passwd);
    }

    @Override
    public String identity() {
        return "Basic";
    }

    @Override
    public String token() {
        return this.token;
    }

    protected String encode(String user, String passwd) {
        byte[] auth = user.concat(":").concat(passwd).getBytes(Charset.forName("UTF-8"));
        if (HIGHT != null) {
            return HIGHT != false ? this.java8Encode(auth) : this.lowJavaEncode(auth);
        }
        try {
            Class.forName("java.util.Base64");
            HIGHT = true;
            return this.java8Encode(auth);
        }
        catch (ClassNotFoundException e) {
            HIGHT = false;
            return this.lowJavaEncode(auth);
        }
    }

    private String java8Encode(byte[] auth) {
        return Base64.getEncoder().encodeToString(auth);
    }

    private String lowJavaEncode(byte[] auth) {
        return DatatypeConverter.printBase64Binary((byte[])auth);
    }

    public String toString() {
        return "BasicAuth{user='" + this.user + '\'' + ", passwd='" + this.passwd + '\'' + '}';
    }
}

