/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.tar;

import io.enoa.toolkit.EoConst;
import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.stream.StreamKit;
import io.enoa.toolkit.text.TextKit;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class DTar {
    public static EnoaBinary cvf(String filename, String text) {
        return DTar.cvf(filename, text, EoConst.CHARSET);
    }

    public static EnoaBinary cvf(String filename, String text, Charset charset) {
        return DTar.cvf(filename, text.getBytes(charset));
    }

    public static EnoaBinary cvf(String filename, EnoaBinary binary) {
        return DTar.cvf(filename, binary.bytes());
    }

    public static EnoaBinary cvf(String filename, byte[] binary) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TarArchiveOutputStream stream = new TarArchiveOutputStream((OutputStream)baos);
            TarArchiveEntry entry = new TarArchiveEntry(TextKit.union((String)"/", (Object[])new Object[]{filename}));
            entry.setSize((long)binary.length);
            stream.putArchiveEntry((ArchiveEntry)entry);
            stream.write(binary, 0, binary.length);
            stream.closeArchiveEntry();
            stream.flush();
            EnoaBinary ret = EnoaBinary.create((byte[])baos.toByteArray());
            StreamKit.close((Closeable[])new Closeable[]{baos, stream});
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

