/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.registry;

import io.enoa.docker.RegistryConfig;
import io.enoa.docker.dket.registry.RError;
import io.enoa.docker.dket.registry.RResp;
import io.enoa.docker.dket.registry.RRet;
import io.enoa.docker.parser.registry.RIParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

abstract class AbstractParser<T>
implements RIParser<T> {
    AbstractParser() {
    }

    @Override
    public RRet<T> parse(RegistryConfig config, RResp resp) {
        if (resp == null) {
            return RRet.nullx();
        }
        String contenttype = resp.contenttype();
        if (!contenttype.contains("json")) {
            return RRet.fail(resp, resp.string());
        }
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        if (kv.exists("errors")) {
            Object ers = kv.get((Object)"errors");
            if (ers instanceof Collection) {
                Collection rs = (Collection)ers;
                List rl = rs.stream().collect(Collectors.toList());
                Object o = rl.get(0);
                Kv ek = Kv.by((Map)((Map)o));
                RError.Builder erb = new RError.Builder().code(ek.string("code")).message(ek.string("message"));
                Object dl = ek.get((Object)"detail");
                if (dl instanceof Map) {
                    erb.detail(Kv.by((Map)((Map)dl)));
                }
                CollectionKit.clear((Map[])new Map[]{ek, kv});
                CollectionKit.clear((Collection[])new Collection[]{rl, rs});
                return RRet.fail(resp, erb.build());
            }
            CollectionKit.clear((Map[])new Map[]{kv});
            return RRet.fail(resp, resp.string());
        }
        CollectionKit.clear((Map[])new Map[]{kv});
        T data = this.ok(config, resp);
        return RRet.ok(resp, data);
    }

    public abstract T ok(RegistryConfig var1, RResp var2);
}

