/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.dockerhub;

import io.enoa.docker.DockerhubConfig;
import io.enoa.docker.dket.dockerhub.search.EHSResult;
import io.enoa.docker.dket.dockerhub.search.EHSearch;
import io.enoa.docker.dket.registry.RResp;
import io.enoa.docker.parser.dockerhub.AbstractDockerhubParser;
import io.enoa.docker.parser.dockerhub.HEExtra;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class EHSearchParser
extends AbstractDockerhubParser<EHSearch> {
    EHSearchParser() {
    }

    static EHSearchParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public EHSearch ok(DockerhubConfig config, RResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        EHSearch.Builder builder = new EHSearch.Builder();
        HEExtra.hubpage((Map)kv, builder);
        builder.results(this.results(kv));
        CollectionKit.clear((Map[])new Map[]{kv});
        return builder.build();
    }

    private List<EHSResult> results(Kv kv) {
        Collection<Kv> kvs = HEExtra.kvs((Map)kv, "results");
        ArrayList<EHSResult> rets = new ArrayList<EHSResult>(kvs.size());
        kvs.forEach(ks -> {
            EHSResult.Builder builder = new EHSResult.Builder().reponame(ks.string("repo_name")).shortdescription(ks.string("short_description")).starcount(ks.integer("star_count")).pullcount(ks.longer("pull_count")).repoowner(ks.string("repo_owner")).isautomated(ks.bool("is_automated")).isofficial(ks.bool("is_official"));
            rets.add(builder.build());
        });
        CollectionKit.clear((Collection[])new Collection[]{kvs});
        return rets;
    }

    private static class Holder {
        private static final EHSearchParser INSTANCE = new EHSearchParser();

        private Holder() {
        }
    }
}

