/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.volume.EVolume;
import io.enoa.docker.dket.docker.volume.EVolumeLs;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.docker.parser.docker.EVolumeParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class EVolumeListParser
extends AbstractParser<EVolumeLs> {
    EVolumeListParser() {
    }

    static EVolumeListParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public EVolumeLs ok(DockerConfig config, DResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        if (CollectionKit.isEmpty((Map)kv).booleanValue()) {
            return null;
        }
        EVolumeLs.Builder builder = new EVolumeLs.Builder().warnings(AEExtra.stringarray((Map)kv, "Warnings")).volumes(this.volumes(kv));
        return builder.build();
    }

    private List<EVolume> volumes(Kv kv) {
        Object vos = kv.get((Object)"Volumes");
        if (!(vos instanceof Collection)) {
            return Collections.emptyList();
        }
        Collection vums = (Collection)vos;
        ArrayList<EVolume> rets = new ArrayList<EVolume>(vums.size());
        vums.forEach(vum -> {
            if (!(vum instanceof Map)) {
                return;
            }
            Kv mk = Kv.by((Map)((Map)vum));
            rets.add(EVolumeParser.instance().volume(mk));
            CollectionKit.clear((Map[])new Map[]{mk});
        });
        return rets;
    }

    private static class Holder {
        private static final EVolumeListParser INSTANCE = new EVolumeListParser();

        private Holder() {
        }
    }
}

