/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.common.EDriver;
import io.enoa.docker.dket.docker.swarm.ECAConfig;
import io.enoa.docker.dket.docker.swarm.EDispatcher;
import io.enoa.docker.dket.docker.swarm.EEncryptionConfig;
import io.enoa.docker.dket.docker.swarm.EExternalCA;
import io.enoa.docker.dket.docker.swarm.EJoinTokens;
import io.enoa.docker.dket.docker.swarm.EOrchestration;
import io.enoa.docker.dket.docker.swarm.ERaft;
import io.enoa.docker.dket.docker.swarm.ESwarmInspect;
import io.enoa.docker.dket.docker.swarm.ESwarmSpec;
import io.enoa.docker.dket.docker.swarm.ETaskDefaults;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.date.DateKit;
import io.enoa.toolkit.map.Kv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class ESwarmInspectParser
extends AbstractParser<ESwarmInspect> {
    ESwarmInspectParser() {
    }

    static ESwarmInspectParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public ESwarmInspect ok(DockerConfig config, DResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        if (CollectionKit.isEmpty((Map)kv).booleanValue()) {
            return null;
        }
        ESwarmInspect.Builder builder = new ESwarmInspect.Builder().id(kv.string("ID")).createdat(DateKit.parse((String)kv.string("CreatedAt"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS")).updatedat(DateKit.parse((String)kv.string("UpdatedAt"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS")).rootrotationinprogress(kv.bool("RootRotationInProgress")).version(AEExtra.version((Map)kv)).spec(this.spec(kv, "Spec")).tlsinfo(AEExtra.tls((Map)kv, "TLSInfo")).jointokens(this.jointokens(kv));
        CollectionKit.clear((Map[])new Map[]{kv});
        return builder.build();
    }

    private EJoinTokens jointokens(Kv kv) {
        Object jt = kv.get((Object)"JoinTokens");
        if (!(jt instanceof Map)) {
            return null;
        }
        Kv tm = Kv.by((Map)((Map)jt));
        EJoinTokens.Builder builder = new EJoinTokens.Builder().worker(tm.string("Worker")).manager(tm.string("Manager"));
        CollectionKit.clear((Map[])new Map[]{tm});
        return builder.build();
    }

    ESwarmSpec spec(Kv kv, String key) {
        Object tdo;
        Object ete;
        Object cact;
        Object dist;
        Object rfo;
        Object spo = kv.get((Object)key);
        if (!(spo instanceof Map)) {
            return null;
        }
        Kv spec = Kv.by((Map)((Map)spo));
        ESwarmSpec.Builder builder = new ESwarmSpec.Builder().name(spec.string("Name")).labels(AEExtra.kv((Map)spec, "Labels"));
        Object oton = spec.get((Object)"Orchestration");
        if (oton instanceof Map) {
            Kv orche = Kv.by((Map)((Map)oton));
            EOrchestration.Builder eob = new EOrchestration.Builder().taskhistoryretentionlimit(orche.integer("TaskHistoryRetentionLimit"));
            CollectionKit.clear((Map[])new Map[]{orche});
            builder.orchestration(eob.build());
        }
        if ((rfo = spec.get((Object)"Raft")) instanceof Map) {
            Kv raft = Kv.by((Map)((Map)rfo));
            ERaft.Builder rfb = new ERaft.Builder().snapshotinterval(raft.longer("SnapshotInterval")).keepoldsnapshots(raft.longer("KeepOldSnapshots")).logentriesforslowfollowers(raft.longer("LogEntriesForSlowFollowers")).electiontick(raft.integer("ElectionTick")).heartbeattick(raft.integer("HeartbeatTick"));
            CollectionKit.clear((Map[])new Map[]{raft});
            builder.raft(rfb.build());
        }
        if ((dist = spec.get((Object)"Dispatcher")) instanceof Map) {
            Kv disp = Kv.by((Map)((Map)dist));
            EDispatcher.Builder drb = new EDispatcher.Builder().heartbeatperiod(disp.longer("HeartbeatPeriod"));
            builder.dispatcher(drb.build());
        }
        if ((cact = spec.get((Object)"CAConfig")) instanceof Map) {
            Kv cacfg = Kv.by((Map)((Map)cact));
            ECAConfig.Builder cab = new ECAConfig.Builder().nodecertexpiry(cacfg.longer("NodeCertExpiry")).signingcacert(cacfg.string("SigningCACert")).signingcakey(cacfg.string("SigningCAKey")).forcerotate(cacfg.longer("ForceRotate"));
            Object extc = cacfg.get((Object)"ExternalCAs");
            if (extc instanceof Collection) {
                Collection exts = (Collection)extc;
                ArrayList<EExternalCA> cas = new ArrayList<EExternalCA>(exts.size());
                exts.forEach(ex -> {
                    if (!(ex instanceof Map)) {
                        return;
                    }
                    Kv etern = Kv.by((Map)((Map)ex));
                    EExternalCA.Builder lcab = new EExternalCA.Builder().protocol(etern.string("Protocol")).url(etern.string("URL")).cacert(etern.string("CACert")).options(AEExtra.kv((Map)etern, "Options"));
                    cas.add(lcab.build());
                    CollectionKit.clear((Map[])new Map[]{etern});
                });
                CollectionKit.clear((Collection[])new Collection[]{exts});
                cab.externalcas(cas);
            }
            builder.caconfig(cab.build());
        }
        if ((ete = spec.get((Object)"EncryptionConfig")) instanceof Map) {
            Kv enc = Kv.by((Map)((Map)ete));
            EEncryptionConfig.Builder cgb = new EEncryptionConfig.Builder().autolockmanagers(enc.bool("AutoLockManagers"));
            CollectionKit.clear((Map[])new Map[]{enc});
            builder.encryptionconfig(cgb.build());
        }
        if ((tdo = spec.get((Object)"TaskDefaults")) instanceof Map) {
            Kv tdm = Kv.by((Map)((Map)tdo));
            ETaskDefaults.Builder tdb = new ETaskDefaults.Builder();
            Object ldr = tdm.get((Object)"LogDriver");
            if (ldr instanceof Map) {
                Kv ldm = Kv.by((Map)((Map)ldr));
                EDriver.Builder edb = new EDriver.Builder().name(ldm.string("Name")).options(AEExtra.kv((Map)ldm, "Options"));
                CollectionKit.clear((Map[])new Map[]{ldm});
                tdb.logdriver(edb.build());
            }
            CollectionKit.clear((Map[])new Map[]{tdm});
            builder.taskdefaults(tdb.build());
        }
        return builder.build();
    }

    private static class Holder {
        private static final ESwarmInspectParser INSTANCE = new ESwarmInspectParser();

        private Holder() {
        }
    }
}

