/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.common.EUser;
import io.enoa.docker.dket.docker.plugin.EInterfaceType;
import io.enoa.docker.dket.docker.plugin.EPlugin;
import io.enoa.docker.dket.docker.plugin.EPluginArg;
import io.enoa.docker.dket.docker.plugin.EPluginConfig;
import io.enoa.docker.dket.docker.plugin.EPluginDevice;
import io.enoa.docker.dket.docker.plugin.EPluginEnv;
import io.enoa.docker.dket.docker.plugin.EPluginInterface;
import io.enoa.docker.dket.docker.plugin.EPluginLinux;
import io.enoa.docker.dket.docker.plugin.EPluginMount;
import io.enoa.docker.dket.docker.plugin.EPluginNetwork;
import io.enoa.docker.dket.docker.plugin.EPluginRootfs;
import io.enoa.docker.dket.docker.plugin.EPluginSetting;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class EPluginParser
extends AbstractParser<EPlugin> {
    EPluginParser() {
    }

    public static EPluginParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public EPlugin ok(DockerConfig config, DResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        EPlugin plugin = this.plugin(kv);
        CollectionKit.clear((Map[])new Map[]{kv});
        return plugin;
    }

    EPlugin plugin(Kv kv) {
        if (CollectionKit.isEmpty((Map)kv).booleanValue()) {
            return null;
        }
        EPlugin.Builder builder = new EPlugin.Builder().id(kv.string("ID")).name(kv.string("Name")).enabled(kv.bool("Enabled")).reference(kv.string("PluginReference")).setting(this.setting(kv)).config(this.config(kv));
        return builder.build();
    }

    private EPluginSetting setting(Kv kv) {
        Object des;
        EPluginSetting.Builder builder = new EPluginSetting.Builder().args(AEExtra.stringarray((Map)kv, "Args")).env(AEExtra.stringarray((Map)kv, "Env"));
        Object mts = kv.get((Object)"Mounts");
        if (mts instanceof Collection) {
            Collection _m = (Collection)mts;
            ArrayList<EPluginMount> mounts = new ArrayList<EPluginMount>(_m.size());
            _m.forEach(m -> {
                Kv mk = Kv.by((Map)((Map)m));
                mounts.add(this.mount(mk));
                CollectionKit.clear((Map[])new Map[]{mk});
            });
            builder.mounts(mounts);
        }
        if ((des = kv.get((Object)"Devices")) instanceof Collection) {
            Collection _d = (Collection)des;
            ArrayList<EPluginDevice> devices = new ArrayList<EPluginDevice>(_d.size());
            _d.forEach(d -> {
                Kv dk = Kv.by((Map)((Map)d));
                devices.add(this.device(dk));
                CollectionKit.clear((Map[])new Map[]{dk});
            });
            builder.devices(devices);
        }
        return builder.build();
    }

    private EPluginConfig config(Kv kv) {
        Object rfs;
        Object arg;
        Object ent;
        Object mtt;
        Object lx;
        Object ut;
        EPluginConfig.Builder builder = new EPluginConfig.Builder().dockerversion(kv.string("DockerVersion")).description(kv.string("Description")).documentation(kv.string("Documentation")).entrypoint(AEExtra.stringarray((Map)kv, "Entrypoint")).workdir(kv.string("WorkDir")).propagatedmount(kv.string("PropagatedMount")).ipchost(kv.bool("IpcHost")).pidhost(kv.bool("PidHost"));
        Object ito = kv.get((Object)"Interface");
        if (ito instanceof Map) {
            Kv itk = Kv.by((Map)((Map)ito));
            builder.interfacex(this.interfacex(itk));
            CollectionKit.clear((Map[])new Map[]{itk});
        }
        if ((ut = kv.get((Object)"User")) instanceof Map) {
            Kv uk = Kv.by((Map)((Map)ut));
            builder.user(this.user(uk));
            CollectionKit.clear((Map[])new Map[]{uk});
        }
        Object nt = kv.get((Object)"Network");
        if (ut instanceof Map) {
            Kv nk = Kv.by((Map)((Map)nt));
            builder.network(this.network(nk));
            CollectionKit.clear((Map[])new Map[]{nk});
        }
        if ((lx = kv.get((Object)"Linux")) instanceof Map) {
            Kv lk = Kv.by((Map)((Map)lx));
            builder.linux(this.linux(lk));
            CollectionKit.clear((Map[])new Map[]{lk});
        }
        if ((mtt = kv.get((Object)"Mounts")) instanceof Collection) {
            Collection mts = (Collection)mtt;
            ArrayList<EPluginMount> mounts = new ArrayList<EPluginMount>(mts.size());
            mts.forEach(mt -> {
                if (!(mt instanceof Map)) {
                    return;
                }
                Kv mk = Kv.by((Map)((Map)mt));
                mounts.add(this.mount(mk));
                CollectionKit.clear((Map[])new Map[]{mk});
            });
            builder.mounts(mounts);
        }
        if ((ent = kv.get((Object)"Env")) instanceof Collection) {
            Collection ents = (Collection)ent;
            ArrayList<EPluginEnv> mounts = new ArrayList<EPluginEnv>(ents.size());
            ents.forEach(mt -> {
                if (!(mt instanceof Map)) {
                    return;
                }
                Kv mk = Kv.by((Map)((Map)mt));
                mounts.add(this.env(mk));
                CollectionKit.clear((Map[])new Map[]{mk});
            });
            builder.env(mounts);
        }
        if ((arg = kv.get((Object)"Arg")) instanceof Collection) {
            Collection args = (Collection)arg;
            ArrayList<EPluginArg> mounts = new ArrayList<EPluginArg>(args.size());
            args.forEach(mt -> {
                if (!(mt instanceof Map)) {
                    return;
                }
                Kv mk = Kv.by((Map)((Map)mt));
                mounts.add(this.arg(mk));
                CollectionKit.clear((Map[])new Map[]{mk});
            });
            builder.arg(mounts);
        }
        if ((rfs = kv.get((Object)"rootfs")) instanceof Map) {
            Kv rk = Kv.by((Map)((Map)rfs));
            builder.rootfs(this.rootfs(rk));
            CollectionKit.clear((Map[])new Map[]{rk});
        }
        return builder.build();
    }

    private EPluginRootfs rootfs(Kv kv) {
        EPluginRootfs.Builder builder = new EPluginRootfs.Builder().diffids(AEExtra.stringarray((Map)kv, " diff_ids")).type(kv.string(" type"));
        return builder.build();
    }

    private EPluginEnv env(Kv kv) {
        EPluginEnv.Builder builder = new EPluginEnv.Builder().description(kv.string("Description")).name(kv.string("Name")).settable(AEExtra.stringarray((Map)kv, "Settable")).value(kv.string("Value"));
        return builder.build();
    }

    private EPluginArg arg(Kv kv) {
        EPluginArg.Builder builder = new EPluginArg.Builder().description(kv.string("Description")).name(kv.string("Name")).settable(AEExtra.stringarray((Map)kv, "Settable")).value(AEExtra.stringarray((Map)kv, "Value"));
        return builder.build();
    }

    private EPluginLinux linux(Kv kv) {
        EPluginLinux.Builder builder = new EPluginLinux.Builder().capabilities(AEExtra.stringarray((Map)kv, " Capabilities")).allowalldevices(kv.bool("AllowAllDevices"));
        Object dt = kv.get((Object)"Devices");
        if (dt instanceof Collection) {
            Collection ds = (Collection)dt;
            ArrayList<EPluginDevice> devices = new ArrayList<EPluginDevice>(ds.size());
            ds.forEach(d -> {
                if (!(d instanceof Map)) {
                    return;
                }
                Kv dk = Kv.by((Map)((Map)d));
                devices.add(this.device(dk));
                CollectionKit.clear((Map[])new Map[]{dk});
            });
            builder.devices(devices);
        }
        return builder.build();
    }

    private EPluginNetwork network(Kv kv) {
        EPluginNetwork.Builder builder = new EPluginNetwork.Builder().type(kv.string("Network"));
        return builder.build();
    }

    private EUser user(Kv kv) {
        EUser.Builder builder = new EUser.Builder().gid(kv.integer("GID")).uid(kv.integer("UID"));
        return builder.build();
    }

    private EPluginInterface interfacex(Kv kv) {
        EPluginInterface.Builder builder = new EPluginInterface.Builder().socket(kv.string("Socket"));
        Object tt = kv.get((Object)"Types");
        if (tt instanceof Collection) {
            Collection ts = (Collection)tt;
            ArrayList<EInterfaceType> tts = new ArrayList<EInterfaceType>(ts.size());
            ts.forEach(t -> {
                Kv tk = Kv.by((Map)((Map)t));
                EInterfaceType.Builder ttb = new EInterfaceType.Builder().capability(tk.string("Capability")).prefix(tk.string("Prefix")).version(tk.string("Version"));
                tts.add(ttb.build());
            });
            builder.types(tts);
        }
        return builder.build();
    }

    private EPluginMount mount(Kv kv) {
        if (CollectionKit.isEmpty((Map)kv).booleanValue()) {
            return null;
        }
        EPluginMount.Builder builder = new EPluginMount.Builder().name(kv.string("Name")).description(kv.string("Description")).settable(AEExtra.stringarray((Map)kv, "Settable")).source(kv.string("Source")).destination(kv.string("Destination")).type(kv.string("Type")).options(AEExtra.stringarray((Map)kv, "Options"));
        return builder.build();
    }

    private EPluginDevice device(Kv kv) {
        if (CollectionKit.isEmpty((Map)kv).booleanValue()) {
            return null;
        }
        EPluginDevice.Builder builder = new EPluginDevice.Builder().name(kv.string("Name")).description(kv.string(" Description")).settable(AEExtra.stringarray((Map)kv, "Settable")).path(kv.string("Path"));
        return builder.build();
    }

    private static class Holder {
        private static final EPluginParser INSTANCE = new EPluginParser();

        private Holder() {
        }
    }
}

