/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.common.EGenericResource;
import io.enoa.docker.dket.docker.common.EResources;
import io.enoa.docker.dket.docker.node.ENode;
import io.enoa.docker.dket.docker.node.ENodeDescription;
import io.enoa.docker.dket.docker.node.ENodeEngine;
import io.enoa.docker.dket.docker.node.ENodePlugin;
import io.enoa.docker.dket.docker.node.ENodeResourceSpec;
import io.enoa.docker.dket.docker.node.ENodeSpec;
import io.enoa.docker.dket.docker.node.ENodeStatus;
import io.enoa.docker.dket.docker.node.EPlatform;
import io.enoa.docker.dket.docker.swarm.EVersion;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.date.DateKit;
import io.enoa.toolkit.map.Kv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ENodeParser
extends AbstractParser<ENode> {
    ENodeParser() {
    }

    static ENodeParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public ENode ok(DockerConfig config, DResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        ENode node = this.node(kv);
        CollectionKit.clear((Map[])new Map[]{kv});
        return node;
    }

    ENode node(Kv kv) {
        ENode.Builder builder = new ENode.Builder().id(kv.string("ID")).createdat(DateKit.parse((String)kv.string("CreatedAt"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS")).updatedat(DateKit.parse((String)kv.string("UpdatedAt"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS")).version(this.version(kv)).spec(this.spec(kv)).description(this.description(kv)).status(this.status(kv, "Status")).managerstatus(this.status(kv, "ManagerStatus"));
        return builder.build();
    }

    private ENodeStatus status(Kv kv, String key) {
        Object ot = kv.get((Object)key);
        if (!(ot instanceof Map)) {
            return null;
        }
        Kv stk = Kv.by((Map)((Map)ot));
        ENodeStatus.Builder builder = new ENodeStatus.Builder().state(stk.string("State")).message(stk.string("Message")).addr(stk.string("Addr"));
        CollectionKit.clear((Map[])new Map[]{stk});
        return builder.build();
    }

    private EVersion version(Kv kv) {
        Object vto = kv.get((Object)"Version");
        if (!(vto instanceof Map)) {
            return null;
        }
        Kv ver = Kv.by((Map)((Map)vto));
        EVersion.Builder builder = new EVersion.Builder().index(ver.integer("Index"));
        return builder.build();
    }

    private ENodeSpec spec(Kv kv) {
        Object spt = kv.get((Object)"Spec");
        if (!(spt instanceof Map)) {
            return null;
        }
        Kv spec = Kv.by((Map)((Map)spt));
        ENodeSpec.Builder builder = new ENodeSpec.Builder().availability(spec.string("Availability")).name(spec.string("Name")).role(spec.string("Role")).labels(AEExtra.kv((Map)spec, "Labels"));
        CollectionKit.clear((Map[])new Map[]{spec});
        return builder.build();
    }

    EPlatform platform(Kv kv) {
        EPlatform.Builder pb = new EPlatform.Builder().architecture(kv.string("Architecture", kv.string("architecture"))).os(kv.string("OS", kv.string("os"))).osversion(kv.string("OSVersion", kv.string("osVersion"))).osfeatures(AEExtra.array((Map)kv, "OSFeatures")).variant(kv.string("Variant", kv.string("variant"))).features(AEExtra.array((Map)kv, "Features"));
        return pb.build();
    }

    private ENodeDescription description(Kv kv) {
        Object ent;
        Object rot;
        Object dot = kv.get((Object)"Description");
        if (!(dot instanceof Map)) {
            return null;
        }
        Kv desn = Kv.by((Map)((Map)dot));
        ENodeDescription.Builder builder = new ENodeDescription.Builder().hostname(desn.string("Hostname"));
        Object plo = desn.get((Object)"Platform");
        if (plo instanceof Map) {
            Kv pak = Kv.by((Map)((Map)plo));
            builder.platform(this.platform(pak));
            CollectionKit.clear((Map[])new Map[]{pak});
        }
        if ((rot = desn.get((Object)"Resources")) instanceof Map) {
            Kv rok = Kv.by((Map)((Map)rot));
            EResources.Builder erb = new EResources.Builder().nanocpus(rok.longer("NanoCPUs")).memorybytes(rok.longer("MemoryBytes"));
            erb.genericresources(this.genericresources(rok, "GenericResources"));
            CollectionKit.clear((Map[])new Map[]{rok});
            builder.resources(erb.build());
        }
        if ((ent = desn.get((Object)"Engine")) instanceof Map) {
            Kv enk = Kv.by((Map)((Map)ent));
            ENodeEngine.Builder neb = new ENodeEngine.Builder().engineversion(enk.string("EngineVersion")).labels(AEExtra.kv((Map)enk, "Labels"));
            Object pto = enk.get((Object)"Plugins");
            if (pto instanceof Collection) {
                Collection pcs = (Collection)pto;
                ArrayList plugins = new ArrayList(pcs.size());
                pcs.forEach(p -> {
                    if (!(p instanceof Map)) {
                        return;
                    }
                    Kv pk = Kv.by((Map)((Map)p));
                    ENodePlugin.Builder npb = new ENodePlugin.Builder().type(pk.string("Type")).name(pk.string("Name"));
                    plugins.add(npb.build());
                });
            }
            builder.engine(neb.build());
        }
        builder.tlsinfo(AEExtra.tls((Map)desn, "TLSInfo"));
        return builder.build();
    }

    List<EGenericResource> genericresources(Kv kv, String key) {
        Object gr = kv.get((Object)key);
        if (!(gr instanceof Collection)) {
            return Collections.emptyList();
        }
        Collection ees = (Collection)gr;
        ArrayList<EGenericResource> rets = new ArrayList<EGenericResource>(ees.size());
        ees.forEach(e -> {
            ENodeResourceSpec.Builder nrsb;
            if (!(e instanceof Map)) {
                return;
            }
            Kv ek = Kv.by((Map)((Map)e));
            EGenericResource.Builder egrb = new EGenericResource.Builder();
            Object nrs = ek.get((Object)"NamedResourceSpec");
            Object drs = ek.get((Object)"DiscreteResourceSpec");
            if (nrs instanceof Map) {
                Kv nrk = Kv.by((Map)((Map)nrs));
                nrsb = new ENodeResourceSpec.Builder().kind(nrk.string("Kind")).value(nrk.integer("Value"));
                egrb.namedresourcespec(nrsb.build());
                CollectionKit.clear((Map[])new Map[]{nrk});
            }
            if (drs instanceof Map) {
                Kv drk = Kv.by((Map)((Map)drs));
                nrsb = new ENodeResourceSpec.Builder().kind(drk.string("Kind")).value(drk.integer("Value"));
                egrb.discreteresourcespec(nrsb.build());
                CollectionKit.clear((Map[])new Map[]{drk});
            }
            rets.add(egrb.build());
            CollectionKit.clear((Map[])new Map[]{ek});
        });
        return rets;
    }

    private static class Holder {
        private static final ENodeParser INSTANCE = new ENodeParser();

        private Holder() {
        }
    }
}

