/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.network.EIPAM;
import io.enoa.docker.dket.docker.network.EIPAMConfig;
import io.enoa.docker.dket.docker.network.ENetwork;
import io.enoa.docker.dket.docker.network.ENetworkContainer;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.date.DateKit;
import io.enoa.toolkit.map.Kv;
import io.enoa.toolkit.value.EnoaValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ENetworkInspectParser
extends AbstractParser<ENetwork> {
    ENetworkInspectParser() {
    }

    static ENetworkInspectParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public ENetwork ok(DockerConfig config, DResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        return this.network(kv);
    }

    ENetwork network(Kv kv) {
        ENetwork.Builder builder = new ENetwork.Builder().name(kv.string("Name")).id(kv.string("Id")).created(DateKit.parse((String)kv.string("Created"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS")).scope(kv.string("Scope")).driver(kv.string("Driver")).enableipv6(kv.bool("EnableIPv6")).internal(kv.bool("Internal")).attachable(kv.bool("Attachable")).ingress(kv.bool("Ingress")).ipam(this.ipam(kv)).containers(this.containers(kv)).options(AEExtra.kv((Map)kv, "Options")).labels(AEExtra.kv((Map)kv, "Labels"));
        return builder.build();
    }

    Map<String, ENetworkContainer> containers(Kv kv) {
        Object cto = kv.get((Object)"Containers");
        if (!(cto instanceof Map)) {
            return null;
        }
        Map conts = (Map)cto;
        HashMap<String, ENetworkContainer> ret = new HashMap<String, ENetworkContainer>(conts.size());
        conts.forEach((key, val) -> {
            if (!(val instanceof Map)) {
                return;
            }
            Kv enc = Kv.by((Map)((Map)val));
            ENetworkContainer.Builder builder = new ENetworkContainer.Builder().name(enc.string("Name")).endpointid(enc.string("EndpointID")).macaddress(enc.string("MacAddress")).ipv4address(enc.string("IPv4Address")).ipv6address(enc.string("IPv6Address"));
            CollectionKit.clear((Map[])new Map[]{enc});
            ret.put(EnoaValue.with((Object)key).string(), builder.build());
        });
        return ret;
    }

    EIPAM ipam(Kv kv) {
        Object ipgo;
        Object ipmo = kv.get((Object)"IPAM");
        if (!(ipmo instanceof Map)) {
            return null;
        }
        Kv ipam = Kv.by((Map)((Map)ipmo));
        EIPAM.Builder builder = new EIPAM.Builder().driver(ipam.string("Driver", "default"));
        Object cfgo = ipam.get((Object)"Config");
        if (cfgo instanceof Collection) {
            Collection cgc = (Collection)cfgo;
            ArrayList<EIPAMConfig> cfgs = new ArrayList<EIPAMConfig>(cgc.size());
            cgc.forEach(c -> {
                if (!(c instanceof Map)) {
                    return;
                }
                Kv cgk = Kv.by((Map)((Map)c));
                EIPAMConfig.Builder mcb = new EIPAMConfig.Builder().gateway(cgk.string("Gateway")).subnet(cgk.string("Subnet"));
                cfgs.add(mcb.build());
                CollectionKit.clear((Map[])new Map[]{cgk});
            });
            builder.config(cfgs);
        }
        if ((ipgo = ipam.get((Object)"Options")) instanceof Collection) {
            Collection ipc = (Collection)ipgo;
            List<Kv> cfgs = ipc.stream().map(it -> Kv.by((Map)((Map)it))).collect(Collectors.toList());
            builder.options(cfgs);
        }
        return builder.build();
    }

    private static class Holder {
        private static final ENetworkInspectParser INSTANCE = new ENetworkInspectParser();

        private Holder() {
        }
    }
}

