/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.image.EContainerConfig;
import io.enoa.docker.dket.docker.image.EHealthcheck;
import io.enoa.docker.dket.docker.image.EIInspect;
import io.enoa.docker.dket.docker.image.EIMetadata;
import io.enoa.docker.dket.docker.image.ERootFS;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.date.DateKit;
import io.enoa.toolkit.map.Kv;
import java.util.Map;

class EImageInspectParser
extends AbstractParser<EIInspect> {
    EImageInspectParser() {
    }

    static EImageInspectParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public EIInspect ok(DockerConfig config, DResp resp) {
        Kv kv = (Kv)config.json().parse(resp.string(), Kv.class);
        EContainerConfig containerconfig = this.containerconfig(kv);
        EIInspect.Builder builder = new EIInspect.Builder().id(kv.string("Id")).repotags(AEExtra.stringarray((Map)kv, "RepoTags")).repodigests(AEExtra.stringarray((Map)kv, "RepoDigests")).parent(kv.string("Parent")).comment(kv.string("Comment")).created(DateKit.parse((String)kv.string("Created"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS")).container(kv.string("Container")).containerconfig(containerconfig).config(containerconfig).dockerversion(kv.string("DockerVersion")).author(kv.string("Author")).architecture(kv.string("Architecture")).os(kv.string("Os")).osversion(kv.string("OsVersion")).size(kv.longer("Size")).virtualsize(kv.longer("VirtualSize")).graphdriver(AEExtra.graphdriver((Map)kv, "GraphDriver")).rootfs(this.rootfs(kv)).metadata(this.metadata(kv));
        CollectionKit.clear((Map[])new Map[]{kv});
        return builder.build();
    }

    private EIMetadata metadata(Kv kv) {
        Object mot = kv.get((Object)"Metadata");
        if (!(mot instanceof Map)) {
            return null;
        }
        Kv metadata = Kv.by((Map)((Map)mot));
        EIMetadata.Builder builder = new EIMetadata.Builder().lasttagtime(AEExtra.date((Map)metadata, "LastTagTime"));
        CollectionKit.clear((Map[])new Map[]{metadata});
        return builder.build();
    }

    private ERootFS rootfs(Kv kv) {
        Object rotf = kv.get((Object)"RootFS");
        if (!(rotf instanceof Map)) {
            return null;
        }
        Kv rootfs = Kv.by((Map)((Map)rotf));
        ERootFS.Builder builder = new ERootFS.Builder().type(rootfs.string("Type")).layers(AEExtra.stringarray((Map)rootfs, "Layers")).baselayer(rootfs.string("BaseLayer"));
        return builder.build();
    }

    private EContainerConfig containerconfig(Kv kv) {
        Object cog = kv.get((Object)"Config");
        if (!(cog instanceof Map)) {
            return null;
        }
        Kv config = Kv.by((Map)((Map)cog));
        EContainerConfig.Builder builder = new EContainerConfig.Builder().hostname(config.string("Hostname")).domainname(config.string("Domainname")).user(config.string(" User")).attachstdin(config.bool("AttachStdin")).attachstdout(config.bool("AttachStdout")).attachstderr(config.bool("AttachStderr")).exposedports(Kv.by((Map)((Map)config.as("ExposedPorts")))).tty(config.bool("Tty")).openstdin(config.bool("OpenStdin")).stdinonce(config.bool("StdinOnce")).env(AEExtra.stringarray((Map)config, "Env")).cmd(AEExtra.stringarray((Map)config, "Cmd")).healthcheck(this.healthcheck(config)).argsescaped(config.bool("ArgsEscaped")).image(config.string("Image")).volumes(Kv.by((Map)((Map)config.as("Volumes")))).workingdir(config.string("WorkingDir")).entrypoint(AEExtra.stringarray((Map)config, "Entrypoint")).networkdisabled(kv.bool("NetworkDisabled")).macaddress(kv.string("MacAddress")).onbuild(AEExtra.stringarray((Map)config, "OnBuild")).labels(Kv.by((Map)((Map)config.as("Labels")))).stopsignal(config.string("StopSignal", "SIGTERM")).stoptimeout(config.integer("StopTimeout", Integer.valueOf(10))).shell(AEExtra.stringarray((Map)config, "Shell"));
        CollectionKit.clear((Map[])new Map[]{config});
        return builder.build();
    }

    private EHealthcheck healthcheck(Kv kv) {
        Object hto = kv.get((Object)"Healthcheck");
        if (!(hto instanceof Map)) {
            return null;
        }
        Kv healthcheck = Kv.by((Map)((Map)hto));
        EHealthcheck.Builder builder = new EHealthcheck.Builder().test(AEExtra.stringarray((Map)healthcheck, "Test")).interval(healthcheck.integer("Interval")).timeout(healthcheck.integer("Timeout")).retries(healthcheck.integer("Retries")).startperiod(healthcheck.integer("StartPeriod"));
        CollectionKit.clear((Map[])new Map[]{healthcheck});
        return builder.build();
    }

    private static class Holder {
        private static final EImageInspectParser INSTANCE = new EImageInspectParser();

        private Holder() {
        }
    }
}

