/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.parser.docker;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.container.EContainer;
import io.enoa.docker.dket.docker.container.EPort;
import io.enoa.docker.parser.docker.AEExtra;
import io.enoa.docker.parser.docker.AbstractParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class EContainerListParser
extends AbstractParser<List<EContainer>> {
    EContainerListParser() {
    }

    static EContainerListParser instance() {
        return Holder.INSTANCE;
    }

    @Override
    public List<EContainer> ok(DockerConfig config, DResp resp) {
        List kvs = config.json().parseArray(resp.string(), Kv.class);
        if (CollectionKit.isEmpty((Collection)kvs).booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<EContainer> rets = new ArrayList<EContainer>(kvs.size());
        kvs.forEach(kv -> rets.add(this.container((Kv)kv)));
        CollectionKit.clear((Collection[])new Collection[]{kvs});
        return rets;
    }

    EContainer container(Kv kv) {
        EContainer.Builder builder = new EContainer.Builder();
        builder.id(kv.string("Id")).names(AEExtra.stringarray((Map)kv, "Names")).image(kv.string("Image")).imageid(kv.string("ImageID")).command(kv.string("Command")).created(kv.longer("Created")).ports(this.ports(kv));
        builder.labels(kv.get((Object)"Labels"));
        builder.state(kv.string("State")).status(kv.string("Status")).hostconfig(AEExtra.hostconfig((Map)kv)).networksetting(AEExtra.networksetting((Map)kv)).mounts(AEExtra.mounts((Map)kv));
        return builder.build();
    }

    private List<EPort> ports(Kv kv) {
        Object ports = kv.get((Object)"Ports");
        if (ports instanceof Collection) {
            Collection _pots = (Collection)ports;
            ArrayList<EPort> pots = new ArrayList<EPort>(_pots.size());
            _pots.forEach(p -> {
                if (!(p instanceof Map)) {
                    return;
                }
                Kv mp = Kv.by((Map)((Map)p));
                EPort.Builder epb = new EPort.Builder().ip(mp.string("IP")).privateport(mp.integer("PrivatePort")).publicport(mp.integer("PublicPort")).type(mp.string("Type"));
                pots.add(epb.build());
            });
            return pots;
        }
        return Collections.emptyList();
    }

    private static class Holder {
        private static final EContainerListParser INSTANCE = new EContainerListParser();

        private Holder() {
        }
    }
}

