/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dqp.dockerhub;

import io.enoa.docker.dqp.DQR;
import io.enoa.docker.dqp.common.DQPPage;

public class DQPSearch
extends DQPPage<DQPSearch> {
    private String q;
    private Boolean automated = Boolean.FALSE;
    private Boolean official = Boolean.FALSE;
    private Integer pullcount = 0;
    private Integer starcount = 0;

    public static DQPSearch create() {
        return new DQPSearch();
    }

    public DQPSearch q(String q) {
        this.q = q;
        return this;
    }

    public DQPSearch automated() {
        return this.automated(Boolean.TRUE);
    }

    public DQPSearch automated(Boolean automated) {
        this.automated = automated;
        return this;
    }

    public DQPSearch official() {
        this.official(Boolean.TRUE);
        return this;
    }

    public DQPSearch official(Boolean official) {
        this.official = official;
        return this;
    }

    public DQPSearch pullcount(Integer pullcount) {
        this.pullcount = pullcount;
        return this;
    }

    public DQPSearch starcount(Integer starcount) {
        this.starcount = starcount;
        return this;
    }

    @Override
    public DQR dqr() {
        DQR dqr = DQR.create().put(super.dqr());
        dqr.put("q", this.q);
        if (this.automated.booleanValue()) {
            dqr.put("is_automated", Boolean.TRUE);
        }
        if (this.official.booleanValue()) {
            dqr.put("is_official", Boolean.TRUE);
        }
        if (this.pullcount != 0) {
            dqr.put("pull_count", this.pullcount);
        }
        if (this.starcount != 0) {
            dqr.put("star_count", this.starcount);
        }
        return dqr;
    }
}

