/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dqp.docker.container;

import io.enoa.docker.dqp.DQP;
import io.enoa.docker.dqp.DQR;

public class DQPContainerLogs
implements DQP {
    private boolean follow;
    private boolean stdout;
    private boolean stderr;
    private int since = 0;
    private int unit = 0;
    private boolean timestamps;
    private String tail = "all";

    public static DQPContainerLogs create() {
        return new DQPContainerLogs();
    }

    public DQPContainerLogs follow() {
        return this.follow(true);
    }

    public DQPContainerLogs follow(boolean follow) {
        this.follow = follow;
        return this;
    }

    public DQPContainerLogs stdout() {
        return this.stdout(true);
    }

    public DQPContainerLogs stdout(boolean stdout) {
        this.stdout = stdout;
        return this;
    }

    public DQPContainerLogs stderr() {
        return this.stderr(true);
    }

    public DQPContainerLogs stderr(boolean stderr) {
        this.stderr = stderr;
        return this;
    }

    public DQPContainerLogs since(int since) {
        this.since = since;
        return this;
    }

    public DQPContainerLogs unit(int unit) {
        this.unit = unit;
        return this;
    }

    public DQPContainerLogs timestamps() {
        return this.timestamps(true);
    }

    public DQPContainerLogs timestamps(boolean timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public DQPContainerLogs tail(String tail) {
        this.tail = tail;
        return this;
    }

    @Override
    public DQR dqr() {
        DQR dqr = DQR.create();
        if (this.follow) {
            dqr.put("follow", this.follow);
        }
        if (this.stdout) {
            dqr.put("stdout", this.stdout);
        }
        if (this.stderr) {
            dqr.put("stderr", this.stderr);
        }
        if (this.timestamps) {
            dqr.put("timestamps", this.timestamps);
        }
        if (this.since != 0) {
            dqr.put("since", this.since);
        }
        if (this.unit != 0) {
            dqr.put("unit", this.unit);
        }
        if (!this.tail.equals("all")) {
            dqr.put("tail", this.tail);
        }
        return dqr;
    }
}

