/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dqp.common;

import io.enoa.docker.dqp.DQP;
import io.enoa.docker.dqp.DQR;
import io.enoa.json.Json;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.convert.ConvertKit;
import io.enoa.toolkit.map.Kv;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DQPFilter<T extends DQPFilter>
implements DQP {
    private Map<String, Set<String>> filter;

    public static DQPFilter create() {
        return new DQPFilter();
    }

    public T filter(String name, String value) {
        Set<String> arr;
        if (this.filter == null) {
            this.filter = new HashMap<String, Set<String>>();
        }
        if (CollectionKit.isEmpty(arr = this.filter.get(name)).booleanValue()) {
            arr = new HashSet<String>();
        }
        arr.add(value);
        this.filter.put(name, arr);
        return (T)this;
    }

    public T filter(String name, String ... vals) {
        return this.filter(name, Stream.of(vals).collect(Collectors.toSet()));
    }

    public T filter(String name, Collection<String> vals) {
        Set<String> arr;
        if (this.filter == null) {
            this.filter = new HashMap<String, Set<String>>();
        }
        if (CollectionKit.isEmpty(arr = this.filter.get(name)).booleanValue()) {
            arr = new HashSet<String>();
        }
        arr.addAll(vals);
        this.filter.put(name, arr);
        return (T)this;
    }

    public T filter(Map<String, Set<String>> filter) {
        this.filter = filter;
        return (T)this;
    }

    public T filter(Kv filter) {
        filter.forEach((key, val) -> this.filter((String)key, ConvertKit.string((Object)val)));
        return (T)this;
    }

    @Override
    public DQR dqr() {
        DQR dqr = DQR.create();
        if (this.filter != null) {
            dqr.putIf("filters", Json.toJson(this.filter));
        }
        return dqr;
    }
}

