/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dqp;

import io.enoa.http.protocol.HttpPara;
import io.enoa.json.Json;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.value.EnoaValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DQR
implements Serializable {
    private Kv kv = Kv.create();
    private static final DQR EMPTY = new DQR();

    private DQR() {
    }

    public static DQR empty() {
        return EMPTY;
    }

    public static DQR create() {
        return new DQR();
    }

    public DQR put(String name, Object value) {
        ArrayList<Object> _lo;
        if (name == null) {
            return this;
        }
        if (value == null) {
            return this;
        }
        Object _v = this.kv.get((Object)name);
        if (_v == null) {
            this.kv.set(name, value);
            return this;
        }
        Object _o = this.kv.get((Object)name);
        if (_o instanceof List) {
            _lo = (ArrayList<Object>)_o;
            _lo.add(value);
        } else {
            _lo = new ArrayList<Object>();
            _lo.add(_o);
            _lo.add(value);
        }
        this.kv.set(name, _lo);
        return this;
    }

    public DQR putIf(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (value instanceof String && TextKit.blanky((String)((String)value))) {
            return this;
        }
        return this.put(name, value);
    }

    public DQR put(String name, Collection collection) {
        if (collection == null) {
            return this;
        }
        collection.forEach(col -> this.put(name, col));
        return this;
    }

    public DQR putIf(String name, Collection collection) {
        if (CollectionKit.isEmpty((Collection)collection).booleanValue()) {
            return this;
        }
        return this.put(name, collection);
    }

    public DQR put(DQR dqr) {
        if (dqr == null) {
            return this;
        }
        if (CollectionKit.isEmpty((Map)dqr.kv).booleanValue()) {
            return this;
        }
        dqr.kv.forEach(this::put);
        return this;
    }

    public DQR putIf(DQR dqr) {
        return this.put(dqr);
    }

    public Set<HttpPara> http() {
        if (CollectionKit.isEmpty((Map)this.kv).booleanValue()) {
            return Collections.emptySet();
        }
        HashSet<HttpPara> paras = new HashSet<HttpPara>();
        this.kv.forEach((key, val) -> {
            if (val instanceof Collection) {
                ((Collection)val).forEach(obj -> paras.add(new HttpPara(key, EnoaValue.with((Object)obj).string())));
            } else {
                paras.add(new HttpPara(key, EnoaValue.with((Object)val).string()));
            }
        });
        return paras;
    }

    public String string() {
        StringBuilder text = new StringBuilder();
        this.kv.forEach((key, val) -> {
            if (val instanceof Collection) {
                ((Collection)val).forEach(obj -> text.append((String)key).append("=").append(EnoaValue.with((Object)val).string()));
            } else {
                text.append((String)key).append("=").append(EnoaValue.with((Object)val).string());
            }
            text.append("&");
        });
        if (text.length() == 0) {
            return null;
        }
        return text.deleteCharAt(text.length() - 1).toString();
    }

    public String json() {
        return Json.toJson((Object)this.kv);
    }

    public EnoaValue value(String name) {
        return this.kv.value(name);
    }

    public DQR clear() {
        CollectionKit.clear((Map[])new Map[]{this.kv});
        return this;
    }

    public String toString() {
        return this.json();
    }
}

