/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dqp;

import io.enoa.http.protocol.HttpHeader;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Nv;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DQH {
    private Set<Nv> nvs = new HashSet<Nv>();
    private static DQH EMPTY = new DQH();

    public static DQH empty() {
        return EMPTY;
    }

    public static DQH create() {
        return new DQH();
    }

    public DQH add(String name, Object value) {
        this.nvs.add(Nv.create((String)name, (Object)value));
        return this;
    }

    public DQH addIf(String name, Object value) {
        if (value == null) {
            return this;
        }
        return this.add(name, value);
    }

    public DQH add(Collection<Nv> nvs) {
        if (CollectionKit.isEmpty(nvs).booleanValue()) {
            return this;
        }
        this.nvs.addAll(nvs);
        return this;
    }

    public DQH addIf(Collection<Nv> nvs) {
        return this.add(nvs);
    }

    public DQH add(DQH dqh) {
        if (dqh == null) {
            return this;
        }
        if (CollectionKit.isEmpty(dqh.nvs).booleanValue()) {
            return this;
        }
        return this.add(dqh.nvs);
    }

    public DQH addIf(DQH dqh) {
        return this.add(dqh);
    }

    public DQH clear() {
        CollectionKit.clear((Collection[])new Collection[]{this.nvs});
        return this;
    }

    public Set<HttpHeader> headers() {
        if (CollectionKit.isEmpty(this.nvs).booleanValue()) {
            return Collections.emptySet();
        }
        return this.nvs.stream().map(nv -> new HttpHeader(nv.name(), nv.value().string())).collect(Collectors.toSet());
    }
}

