/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dket.registry;

import io.enoa.docker.dket.AbstractDRRet;
import io.enoa.docker.dket.registry.RError;
import io.enoa.docker.dket.registry.RResp;
import io.enoa.json.Json;

public class RRet<T>
extends AbstractDRRet {
    private RResp origin;
    private boolean ok;
    private T data;
    private String message;
    private RError error;

    public static <J> RRet<J> fail(RResp origin, RError error) {
        return new Builder().ok(false).origin(origin).message(error.message()).error(error).build();
    }

    public static <J> RRet<J> fail(RResp origin, String message) {
        return new Builder().ok(false).origin(origin).message(message).build();
    }

    public static <J> RRet<J> ok(RResp origin, J data) {
        return new Builder().ok(true).origin(origin).parser(data).build();
    }

    public static <J> RRet<J> nullx() {
        return RRet.fail(null, (String)null);
    }

    private RRet(Builder<T> builder) {
        this.origin = ((Builder)builder).origin;
        this.ok = ((Builder)builder).ok;
        this.data = ((Builder)builder).data;
        this.message = ((Builder)builder).message;
        this.error = ((Builder)builder).error;
    }

    public RResp origin() {
        return this.origin;
    }

    public boolean ok() {
        return this.ok;
    }

    public T data() {
        return this.data;
    }

    public RError error() {
        return this.error;
    }

    public String message() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.ok ? Json.toJson(this.data) : (this.error == null ? this.message : this.error.toString());
    }

    private static class Builder<K> {
        private RResp origin;
        private boolean ok;
        private K data;
        private String message;
        private RError error;

        private Builder() {
        }

        public RRet<K> build() {
            return new RRet(this);
        }

        public Builder<K> origin(RResp origin) {
            this.origin = origin;
            return this;
        }

        public Builder<K> ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder<K> parser(K data) {
            this.data = data;
            return this;
        }

        public Builder<K> message(String message) {
            this.message = message;
            return this;
        }

        public Builder<K> data(K data) {
            this.data = data;
            return this;
        }

        public Builder<K> error(RError error) {
            this.error = error;
            return this;
        }
    }
}

