/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dket.docker.node;

import io.enoa.docker.dket.AbstractDRRet;
import io.enoa.docker.dket.docker.common.EResources;
import io.enoa.docker.dket.docker.common.ETLSInfo;
import io.enoa.docker.dket.docker.node.ENodeEngine;
import io.enoa.docker.dket.docker.node.EPlatform;

public class ENodeDescription
extends AbstractDRRet {
    private String hostname;
    private EPlatform platform;
    private EResources resources;
    private ENodeEngine engine;
    private ETLSInfo tlsinfo;

    public ENodeDescription(Builder builder) {
        this.hostname = builder.hostname;
        this.platform = builder.platform;
        this.resources = builder.resources;
        this.engine = builder.engine;
        this.tlsinfo = builder.tlsinfo;
    }

    public String hostname() {
        return this.hostname;
    }

    public EPlatform platform() {
        return this.platform;
    }

    public EResources resources() {
        return this.resources;
    }

    public ENodeEngine engine() {
        return this.engine;
    }

    public ETLSInfo tlsinfo() {
        return this.tlsinfo;
    }

    public static class Builder {
        private String hostname;
        private EPlatform platform;
        private EResources resources;
        private ENodeEngine engine;
        private ETLSInfo tlsinfo;

        public ENodeDescription build() {
            return new ENodeDescription(this);
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder platform(EPlatform platform) {
            this.platform = platform;
            return this;
        }

        public Builder resources(EResources resources) {
            this.resources = resources;
            return this;
        }

        public Builder engine(ENodeEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder tlsinfo(ETLSInfo tlsinfo) {
            this.tlsinfo = tlsinfo;
            return this;
        }
    }
}

