/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dket.docker;

import io.enoa.docker.dket.AbstractDRRet;
import io.enoa.docker.dket.docker.DResp;

public class DRet<T>
extends AbstractDRRet {
    private DResp origin;
    private boolean ok;
    private T data;
    private String message;

    public static <J> DRet<J> fail(DResp origin, String message) {
        return DRet.fail(origin, message, null);
    }

    public static <J> DRet<J> fail(DResp origin, String message, J data) {
        return new Builder().ok(false).origin(origin).message(message).data(data).build();
    }

    public static <J> DRet<J> fail(DRet<J> ret) {
        return DRet.fail(ret.origin, ret.message, ret.data);
    }

    public static <J> DRet<J> ok(DResp origin, J data) {
        return new Builder().ok(true).origin(origin).data(data).build();
    }

    public static <J> DRet<J> ok(DRet<J> ret) {
        return DRet.ok(ret.origin, ret.data);
    }

    private DRet(Builder<T> builder) {
        this.origin = ((Builder)builder).origin;
        this.ok = ((Builder)builder).ok;
        this.data = ((Builder)builder).data;
        this.message = ((Builder)builder).message;
    }

    public DResp origin() {
        return this.origin;
    }

    public boolean ok() {
        return this.ok;
    }

    public T data() {
        return this.data;
    }

    public String message() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.origin.string();
    }

    private static class Builder<K> {
        private DResp origin;
        private boolean ok;
        private K data;
        private String message;

        private Builder() {
        }

        public DRet<K> build() {
            return new DRet(this);
        }

        public Builder<K> origin(DResp origin) {
            this.origin = origin;
            return this;
        }

        public Builder<K> ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder<K> data(K data) {
            this.data = data;
            return this;
        }

        public Builder<K> message(String message) {
            this.message = message;
            return this;
        }
    }
}

