/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.dket.docker;

import io.enoa.docker.dket.AbstractDRRet;
import io.enoa.http.protocol.HttpResponse;
import io.enoa.toolkit.binary.EnoaBinary;
import io.enoa.toolkit.text.TextKit;
import java.nio.ByteBuffer;

public class DResp
extends AbstractDRRet {
    private int code;
    private String contenttype;
    private EnoaBinary binary;
    private Object origin;
    private Type type;

    public static DResp create(int code, String contenttype, byte[] bytes) {
        DResp dresp = new DResp();
        dresp.type = Type.UNKNOWN;
        dresp.contenttype = contenttype;
        dresp.code = code;
        dresp.binary = EnoaBinary.create((byte[])bytes);
        return null;
    }

    public static DResp create(HttpResponse response) {
        DResp dresp = new DResp();
        dresp.code = response.code();
        dresp.contenttype = response.header("Content-Type");
        dresp.binary = EnoaBinary.create((byte[])response.body().bytes());
        dresp.origin = response;
        dresp.type = Type.TCP;
        return dresp;
    }

    private DResp() {
    }

    public int code() {
        return this.code;
    }

    public String contenttype() {
        return this.contenttype;
    }

    public Type type() {
        return this.type;
    }

    public Object origin() {
        return this.origin;
    }

    public EnoaBinary binary() {
        return this.binary;
    }

    public String string() {
        return this.binary.string();
    }

    public ByteBuffer bytebuffer() {
        return this.binary.bytebuffer();
    }

    public byte[] bytes() {
        return this.binary.bytes();
    }

    @Override
    public String toString() {
        String text = this.string();
        return TextKit.ellipsis((String)text, (int)3000);
    }

    public static enum Type {
        UNKNOWN,
        TCP,
        UNIXSOCKET;

    }
}

