/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.command.docker.origin;

import io.enoa.docker.command.docker.origin.EOriginDockerVolume;
import io.enoa.docker.command.docker.origin.EnoaTCPDocker;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dqp.common.DQPFilter;
import io.enoa.docker.dqp.docker.volume.DQPVolumeList;
import io.enoa.http.Http;
import io.enoa.http.protocol.HttpMethod;
import io.enoa.http.protocol.HttpResponse;

public class ETCPDockerVolume
implements EOriginDockerVolume {
    private EnoaTCPDocker docker;

    ETCPDockerVolume(EnoaTCPDocker docker) {
        this.docker = docker;
    }

    @Override
    public DResp list(DQPVolumeList dqp) {
        Http http = this.docker.http("volumes");
        if (dqp != null) {
            http.para(dqp.dqr().http());
        }
        HttpResponse response = http.emit();
        return DResp.create(response);
    }

    @Override
    public DResp create(String body) {
        HttpResponse response = this.docker.http("volumes/create").method(HttpMethod.POST).raw(body, "application/json").emit();
        return DResp.create(response);
    }

    @Override
    public DResp inspect(String id) {
        HttpResponse response = this.docker.http("volumes", id).emit();
        return DResp.create(response);
    }

    @Override
    public DResp remove(String id, Boolean force) {
        HttpResponse response = this.docker.http("volumes", id).method(HttpMethod.DELETE).para("force", (Object)force).emit();
        return DResp.create(response);
    }

    @Override
    public DResp prune(DQPFilter dqp) {
        Http http = this.docker.http("volumes/prune").method(HttpMethod.POST);
        if (dqp != null) {
            http.para(dqp.dqr().http());
        }
        HttpResponse response = http.emit();
        return DResp.create(response);
    }
}

