/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.command.docker.origin;

import io.enoa.docker.command.docker.origin.EOriginDockerSwarm;
import io.enoa.docker.command.docker.origin.EnoaTCPDocker;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dqp.docker.swarm.DQPSwarmUpdate;
import io.enoa.http.Http;
import io.enoa.http.protocol.HttpMethod;
import io.enoa.http.protocol.HttpResponse;

public class ETCPDockerDockerSwarm
implements EOriginDockerSwarm {
    private EnoaTCPDocker docker;

    ETCPDockerDockerSwarm(EnoaTCPDocker docker) {
        this.docker = docker;
    }

    @Override
    public DResp inspect() {
        HttpResponse response = this.docker.http("swarm").emit();
        return DResp.create(response);
    }

    @Override
    public DResp init(String body) {
        HttpResponse response = this.docker.http("swarm/init").method(HttpMethod.POST).raw(body, "application/json").emit();
        return DResp.create(response);
    }

    @Override
    public DResp join(String body) {
        HttpResponse response = this.docker.http("swarm/join").method(HttpMethod.POST).raw(body, "application/json").emit();
        return DResp.create(response);
    }

    @Override
    public DResp leave(boolean force) {
        HttpResponse response = this.docker.http("swarm/leave").method(HttpMethod.POST).para("force", (Object)force).emit();
        return DResp.create(response);
    }

    @Override
    public DResp update(DQPSwarmUpdate dqp, String body) {
        Http http = this.docker.http("swarm/update").method(HttpMethod.POST).raw(body, "application/json");
        if (dqp != null) {
            http.para(dqp.dqr().http());
        }
        HttpResponse response = http.emit();
        return DResp.create(response);
    }

    @Override
    public DResp unlockkey() {
        HttpResponse response = this.docker.http("swarm/unlockkey").emit();
        return DResp.create(response);
    }

    @Override
    public DResp unlock(String body) {
        HttpResponse response = this.docker.http("swarm/unlock").raw(body, "application/json").emit();
        return DResp.create(response);
    }
}

