/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.command.docker.generic;

import io.enoa.docker.DockerConfig;
import io.enoa.docker.command.docker.origin.EOriginDockerSystem;
import io.enoa.docker.command.docker.origin.OriginDocker;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.DRet;
import io.enoa.docker.dqp.docker.system.DQPMonitor;
import io.enoa.docker.dqp.docker.system.DQPSystemAuth;
import io.enoa.docker.parser.docker.DIParser;

public class EGenericDockerSystem {
    private OriginDocker docker;
    private DockerConfig config;
    private EOriginDockerSystem system;

    EGenericDockerSystem(OriginDocker docker) {
        this.docker = docker;
        this.config = docker._dockerconfig();
        this.system = docker.system();
    }

    public <T> DRet<T> auth(DIParser<T> parser, DQPSystemAuth dqp) {
        DResp resp = this.system.auth(dqp);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> info(DIParser<T> parser) {
        DResp resp = this.system.info();
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> version(DIParser<T> parser) {
        DResp resp = this.system.version();
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> ping(DIParser<T> parser) {
        DResp resp = this.system.ping();
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> monitor(DIParser<T> parser) {
        return this.monitor(parser, null);
    }

    public <T> DRet<T> monitor(DIParser<T> parser, DQPMonitor dqp) {
        DResp resp = this.system.monitor(dqp);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> df(DIParser<T> parser) {
        DResp resp = this.system.df();
        return parser.parse(this.config, resp);
    }
}

