/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.command.docker.generic;

import io.enoa.chunk.Chunk;
import io.enoa.docker.DockerConfig;
import io.enoa.docker.command.docker.origin.EOriginDockerImage;
import io.enoa.docker.command.docker.origin.OriginDocker;
import io.enoa.docker.dket.docker.DResp;
import io.enoa.docker.dket.docker.DRet;
import io.enoa.docker.dqp.common.DQPFilter;
import io.enoa.docker.dqp.docker.image.DQPImageBuild;
import io.enoa.docker.dqp.docker.image.DQPImageCommit;
import io.enoa.docker.dqp.docker.image.DQPImageCreate;
import io.enoa.docker.dqp.docker.image.DQPImageExport;
import io.enoa.docker.dqp.docker.image.DQPImageList;
import io.enoa.docker.dqp.docker.image.DQPImageLoad;
import io.enoa.docker.dqp.docker.image.DQPImagePush;
import io.enoa.docker.dqp.docker.image.DQPImageRmi;
import io.enoa.docker.dqp.docker.image.DQPImageSearch;
import io.enoa.docker.dqp.docker.image.DQPImageTag;
import io.enoa.docker.parser.docker.DIParser;
import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import io.enoa.toolkit.value.Void;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EGenericDockerImage {
    private OriginDocker docker;
    private DockerConfig config;
    private EOriginDockerImage image;

    EGenericDockerImage(OriginDocker docker) {
        this.docker = docker;
        this.config = docker._dockerconfig();
        this.image = docker.image();
    }

    private DRet<List<Kv>> linestolist(DResp origin) {
        Object[] lines = origin.string().split("\n");
        if (CollectionKit.isEmpty((Object[])lines).booleanValue()) {
            return DRet.ok(origin, Collections.emptyList());
        }
        List kvs = Stream.of(lines).map(line -> (Kv)this.config.json().parse(line, Kv.class)).collect(Collectors.toList());
        return DRet.ok(origin, kvs);
    }

    public <T> DRet<List<T>> list(DIParser<List<T>> parser) {
        return this.list(parser, null);
    }

    public <T> DRet<List<T>> list(DIParser<List<T>> parser, DQPImageList dqp) {
        DResp resp = this.image.list(dqp);
        return parser.parse(this.config, resp);
    }

    public DRet<List<Kv>> build(String dockerfile, DQPImageBuild dqp) {
        DResp resp = this.image.build(dockerfile, dqp);
        return this.linestolist(resp);
    }

    public DRet<List<Kv>> build(String dockerfile, DQPImageBuild dqp, Chunk chunk) {
        DResp resp = this.image.build(dockerfile, dqp, chunk);
        return this.linestolist(resp);
    }

    public <T> DRet<T> prunebuild(DIParser<T> parser) {
        DResp resp = this.image.prunebuild();
        return parser.parse(this.config, resp);
    }

    public DRet<List<Kv>> create(DQPImageCreate dqp) {
        DResp resp = this.image.create(dqp);
        return this.linestolist(resp);
    }

    public DRet<List<Kv>> create(DQPImageCreate dqp, String body) {
        DResp resp = this.image.create(dqp, body);
        return this.linestolist(resp);
    }

    public DRet<List<Kv>> create(DQPImageCreate dqp, Chunk chunk) {
        DResp resp = this.image.create(dqp, chunk);
        return this.linestolist(resp);
    }

    public DRet<List<Kv>> create(DQPImageCreate dqp, String body, Chunk chunk) {
        DResp resp = this.image.create(dqp, body, chunk);
        return this.linestolist(resp);
    }

    public <T> DRet<T> inspect(DIParser<T> parser, String id) {
        DResp resp = this.image.inspect(id);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<List<T>> history(DIParser<List<T>> parser, String id) {
        DResp resp = this.image.history(id);
        return parser.parse(this.config, resp);
    }

    public DRet<Void> push(String id) {
        return this.push(id, (DQPImagePush)null);
    }

    public DRet<Void> push(String id, DQPImagePush dqp) {
        DResp resp = this.image.push(id, dqp, null);
        return DIParser.voidx().parse(this.config, resp);
    }

    public DRet<Void> push(String id, Chunk chunk) {
        return this.push(id, null, chunk);
    }

    public DRet<Void> push(String id, DQPImagePush dqp, Chunk chunk) {
        DResp resp = this.image.push(id, dqp, chunk);
        return DIParser.voidx().parse(this.config, resp);
    }

    public DRet<Void> tag(String id, DQPImageTag dqp) {
        DResp resp = this.image.tag(id, dqp);
        return DIParser.voidx().parse(this.config, resp);
    }

    public <T> DRet<List<T>> remove(DIParser<List<T>> parser, String id) {
        return this.remove(parser, id, null);
    }

    public <T> DRet<List<T>> remove(DIParser<List<T>> parser, String id, DQPImageRmi dqp) {
        DResp resp = this.image.remove(id, dqp);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<List<T>> search(DIParser<List<T>> parser, DQPImageSearch dqp) {
        DResp resp = this.image.search(dqp);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> pruneimage(DIParser<T> parser) {
        return this.pruneimage(parser, null);
    }

    public <T> DRet<T> pruneimage(DIParser<T> parser, DQPFilter dqp) {
        DResp resp = this.image.pruneimage(dqp);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> commit(DIParser<T> parser, String body) {
        return this.commit(parser, body, null);
    }

    public <T> DRet<T> commit(DIParser<T> parser, String body, DQPImageCommit dqp) {
        DResp resp = this.image.commit(body, dqp);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> export(DIParser<T> parser, String id) {
        DResp resp = this.image.export(id);
        return parser.parse(this.config, resp);
    }

    public <T> DRet<T> export(DIParser<T> parser, DQPImageExport dqp) {
        DResp resp = this.image.export(dqp);
        return parser.parse(this.config, resp);
    }

    public DRet<Void> load(byte[] binary) {
        return this.load(binary, null);
    }

    public DRet<Void> load(byte[] binary, DQPImageLoad dqp) {
        DResp resp = this.image.load(binary, dqp);
        return DIParser.voidx().parse(this.config, resp);
    }
}

