/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker.command.docker.eo;

import io.enoa.chunk.Chunk;
import io.enoa.docker.DockerConfig;
import io.enoa.docker.command.docker.eo.EnoaDockerConfig;
import io.enoa.docker.command.docker.eo.EnoaDockerContainer;
import io.enoa.docker.command.docker.eo.EnoaDockerDistribution;
import io.enoa.docker.command.docker.eo.EnoaDockerExec;
import io.enoa.docker.command.docker.eo.EnoaDockerImage;
import io.enoa.docker.command.docker.eo.EnoaDockerNetwork;
import io.enoa.docker.command.docker.eo.EnoaDockerNode;
import io.enoa.docker.command.docker.eo.EnoaDockerPlugin;
import io.enoa.docker.command.docker.eo.EnoaDockerSecret;
import io.enoa.docker.command.docker.eo.EnoaDockerService;
import io.enoa.docker.command.docker.eo.EnoaDockerSwarm;
import io.enoa.docker.command.docker.eo.EnoaDockerSystem;
import io.enoa.docker.command.docker.eo.EnoaDockerTask;
import io.enoa.docker.command.docker.eo.EnoaDockerVolume;
import io.enoa.docker.command.docker.eo.EoDocker;
import io.enoa.docker.command.docker.generic.GenericDocker;
import io.enoa.docker.dket.docker.DRet;
import io.enoa.docker.dket.docker.common.ECreatedWithWarning;
import io.enoa.docker.dket.docker.container.ECWait;
import io.enoa.docker.dket.docker.dockerinfo.EDockerInfo;
import io.enoa.docker.dket.docker.run.EDRun;
import io.enoa.docker.dqp.DQP;
import io.enoa.docker.dqp.common.DQPResize;
import io.enoa.docker.dqp.docker.container.DQPContainerCreate;
import io.enoa.docker.parser.docker.DIParser;
import io.enoa.toolkit.convert.ConvertKit;
import io.enoa.toolkit.text.TextKit;
import io.enoa.toolkit.thread.TrdKit;
import io.enoa.toolkit.value.Void;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class EnoaDockerImpl
implements EoDocker {
    private GenericDocker docker;
    private EnoaDockerContainer container;
    private EnoaDockerImage image;
    private EnoaDockerNetwork network;
    private EnoaDockerVolume volume;
    private EnoaDockerExec exec;
    private EnoaDockerSwarm swarm;
    private EnoaDockerNode node;
    private EnoaDockerService service;
    private EnoaDockerTask task;
    private EnoaDockerSecret secret;
    private EnoaDockerConfig config;
    private EnoaDockerPlugin plugin;
    private EnoaDockerSystem system;
    private EnoaDockerDistribution distribution;

    public EnoaDockerImpl(GenericDocker docker) {
        this.docker = docker;
        this.container = new EnoaDockerContainer(this.docker);
        this.image = new EnoaDockerImage(this.docker);
        this.network = new EnoaDockerNetwork(this.docker);
        this.volume = new EnoaDockerVolume(this.docker);
        this.exec = new EnoaDockerExec(this.docker);
        this.swarm = new EnoaDockerSwarm(this.docker);
        this.node = new EnoaDockerNode(this.docker);
        this.service = new EnoaDockerService(this.docker);
        this.task = new EnoaDockerTask(this.docker);
        this.secret = new EnoaDockerSecret(this.docker);
        this.config = new EnoaDockerConfig(this.docker);
        this.plugin = new EnoaDockerPlugin(this.docker);
        this.system = new EnoaDockerSystem(this.docker);
        this.distribution = new EnoaDockerDistribution(this.docker);
    }

    @Override
    public DockerConfig _dockerconfig() {
        return this.docker._dockerconfig();
    }

    @Override
    public DRet<EDockerInfo> info() {
        return this.docker.info(DIParser.dockerinfo());
    }

    @Override
    public EnoaDockerContainer container() {
        return this.container;
    }

    @Override
    public EnoaDockerImage image() {
        return this.image;
    }

    @Override
    public EnoaDockerNetwork network() {
        return this.network;
    }

    @Override
    public EnoaDockerVolume volume() {
        return this.volume;
    }

    @Override
    public EnoaDockerExec exec() {
        return this.exec;
    }

    @Override
    public EnoaDockerSwarm swarm() {
        return this.swarm;
    }

    @Override
    public EnoaDockerNode node() {
        return this.node;
    }

    @Override
    public EnoaDockerService service() {
        return this.service;
    }

    @Override
    public EnoaDockerTask task() {
        return this.task;
    }

    @Override
    public EnoaDockerSecret secret() {
        return this.secret;
    }

    @Override
    public EnoaDockerConfig config() {
        return this.config;
    }

    @Override
    public EnoaDockerPlugin plugin() {
        return this.plugin;
    }

    @Override
    public EnoaDockerSystem system() {
        return this.system;
    }

    @Override
    public EnoaDockerDistribution distribution() {
        return this.distribution;
    }

    @Override
    public DRet<EDRun> run(String name, DQPContainerCreate dqp, Chunk chunk, DQPResize resize) {
        return this.run(name, dqp, chunk, resize, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DRet<EDRun> run(String name, DQPContainerCreate dqp, Chunk chunk, DQPResize resize, boolean isretry) {
        ExecutorService executor = null;
        try {
            List<String> cmds;
            boolean ok;
            DRet<String> retping = this.system().ping();
            if (!retping.ok()) {
                DRet<EDRun> dRet = DRet.fail(retping.origin(), retping.message());
                return dRet;
            }
            if (!retping.data().equals("OK")) {
                DRet<EDRun> dRet = DRet.fail(retping.origin(), retping.data());
                return dRet;
            }
            boolean autoremove = dqp.autoremove();
            boolean isinteractive = dqp.isinteractive();
            boolean showtty = dqp.showtty();
            boolean isdetach = dqp.isdetach();
            DRet<ECreatedWithWarning> retcreate = this.container().create(name, dqp);
            if (!retcreate.ok()) {
                String message = retcreate.message();
                if (!isretry && message.startsWith("Conflict. The container name") && message.contains("is already in use by container")) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    DRet<EDRun> e = this.run(name, dqp, chunk, resize, Boolean.TRUE);
                    return e;
                }
                DRet<EDRun> e = DRet.fail(retcreate.origin(), retcreate.message());
                return e;
            }
            String id = retcreate.data().id();
            AtomicBoolean waitstart = new AtomicBoolean(Boolean.FALSE);
            AtomicReference waitret = new AtomicReference();
            AtomicBoolean waitok = new AtomicBoolean(Boolean.TRUE);
            AtomicBoolean attachok = new AtomicBoolean(Boolean.TRUE);
            executor = Executors.newFixedThreadPool(3);
            CyclicBarrier barrier = new CyclicBarrier(isdetach ? 2 : 3);
            executor.execute(() -> {
                TrdKit.name((Thread)Thread.currentThread(), (String)"docker-wait");
                waitstart.set(Boolean.TRUE);
                DRet<ECWait> retwait = this.container().wait(id, autoremove ? "removed" : "next-exit");
                if (!retwait.ok()) {
                    System.err.println(TextKit.union((String)"WAIT FAILD => ", (Object[])new Object[]{id}));
                }
                waitret.set(retwait);
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    waitok.set(Boolean.FALSE);
                }
            });
            if (isdetach) {
                DRet<Void> retstart = this.container().start(id);
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DRet<EDRun> dRet = DRet.fail(retstart.origin(), e.getMessage());
                    if (executor != null) {
                        executor.shutdown();
                    }
                    return dRet;
                }
                ECWait ecwait = (ECWait)((DRet)waitret.get()).data();
                DRet<EDRun> dRet = retstart.ok() ? DRet.ok(retstart.origin(), new EDRun.Builder().statuscode(ecwait.statuscode()).error(ecwait.error()).log(retstart.ok() ? retcreate.data().id() : null).build()) : DRet.fail(retstart.origin(), retstart.message());
                return dRet;
            }
            AtomicBoolean attachstart = new AtomicBoolean(Boolean.FALSE);
            AtomicReference attachret = new AtomicReference();
            executor.execute(() -> {
                TrdKit.name((Thread)Thread.currentThread(), (String)"docker-attach");
                attachstart.set(Boolean.TRUE);
                DRet<String> attach = this.container().attach(id, DQP.docker().container().attach().stderr().stdin().stream().stdout(), chunk);
                attachret.set(attach);
                try {
                    barrier.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    attachok.set(Boolean.FALSE);
                }
            });
            executor.execute(() -> {
                TrdKit.name((Thread)Thread.currentThread(), (String)"docker-start");
                while (!waitstart.get() || !attachstart.get()) {
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DRet<Void> retstart = this.container().start(id);
                if (!retstart.ok()) {
                    attachret.set(DRet.fail(retstart.origin(), retstart.message()));
                    return;
                }
                if (resize != null) {
                    this.container().resize(id, resize);
                }
            });
            long start = System.currentTimeMillis();
            try {
                barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage(), e);
            }
            if (!waitok.get() || !attachok.get()) {
                DRet<EDRun> e = DRet.fail(null, "CyclicBarrier ERROR");
                return e;
            }
            long end = System.currentTimeMillis();
            if (this._dockerconfig().debug()) {
                System.out.println(TextKit.union((String)"- Run pending time: ", (Object[])new Object[]{end - start, "ms"}));
            }
            DRet ecwait = (DRet)waitret.get();
            DRet ecattach = (DRet)attachret.get();
            ECWait ecwd = (ECWait)ecwait.data();
            boolean bl = ok = ecwait.ok() && ecattach.ok();
            if (!ok) {
                DRet<EDRun> dRet = DRet.fail(ecwait.ok() ? ecwait.origin() : ecattach.origin(), ecwait.ok() ? ecwait.message() : ecattach.message());
                return dRet;
            }
            Object cmdo = dqp.dqr().value("Cmd").get();
            if (cmdo == null) {
                cmds = Collections.emptyList();
            } else {
                if (cmdo instanceof String) {
                    cmds = new ArrayList(1);
                    cmds.add(ConvertKit.string((Object)cmdo));
                }
                cmds = cmdo instanceof Collection ? ((Collection)cmdo).stream().map(item -> ConvertKit.string((Object)item)).collect(Collectors.toList()) : Collections.emptyList();
            }
            EDRun edrun = new EDRun.Builder().log((String)ecattach.data()).error(ecwd.error()).statuscode(ecwd.statuscode()).cmd(cmds).build();
            DRet<EDRun> dRet = DRet.ok(ecattach.origin(), edrun);
            return dRet;
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }
}

