/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker;

import io.enoa.docker.thr.RegistryException;
import io.enoa.http.EoHttp;
import io.enoa.json.EnoaJson;
import io.enoa.json.EoJsonFactory;
import io.enoa.promise.Promise;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;

public class RegistryConfig
implements Serializable {
    private final String host;
    private final Integer port;
    private final Boolean ssl;
    private final Boolean debug;
    private final Boolean dockerhub;
    private final EoHttp http;
    private final String version;
    private final EnoaJson json;
    private final ExecutorService executor;

    public RegistryConfig(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.ssl = builder.ssl;
        this.debug = builder.debug;
        this.http = builder.http;
        this.dockerhub = builder.dockerhub;
        this.version = builder.version;
        this.json = builder.json.json();
        this.executor = builder.executor;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public String version() {
        return this.version;
    }

    public EnoaJson json() {
        return this.json;
    }

    public Boolean dockerhub() {
        return this.dockerhub;
    }

    public String host() {
        return this.host;
    }

    public Integer port() {
        return this.port;
    }

    public Boolean ssl() {
        return this.ssl;
    }

    public Boolean debug() {
        return this.debug;
    }

    public EoHttp http() {
        return this.http;
    }

    public static class Builder {
        private String host;
        private Integer port;
        private Boolean ssl = Boolean.FALSE;
        private Boolean debug = Boolean.FALSE;
        private Boolean dockerhub = Boolean.FALSE;
        private EoHttp http = EoHttp.def();
        private String version = "v2";
        private EoJsonFactory json;
        private ExecutorService executor = Promise.builder().executor().enqueue("Registry Dispatcher");

        public RegistryConfig build() {
            if (this.json == null) {
                throw new RegistryException(EnoaTipKit.message((String)"eo.tip.docker.no_json", (Object[])new Object[0]), new Object[0]);
            }
            return new RegistryConfig(this);
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder dockerhub(Boolean dockerhub) {
            this.dockerhub = dockerhub;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder ssl(Boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder http(EoHttp http) {
            this.http = http;
            return this;
        }

        public Builder json(EoJsonFactory json) {
            this.json = json;
            return this;
        }
    }
}

