/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker;

import io.enoa.docker.AsyncRegistry;
import io.enoa.docker.RegistryConfig;
import io.enoa.docker.async.registry.eo.EAsyncEnoaRegistry;
import io.enoa.docker.async.registry.generic.EAsyncGenericRegistry;
import io.enoa.docker.async.registry.origin.EAsyncOriginRegistry;
import io.enoa.docker.command.registry.eo.EERegistryImpl;
import io.enoa.docker.command.registry.eo.EoRegistry;
import io.enoa.docker.command.registry.generic.EGenericRegistryImpl;
import io.enoa.docker.command.registry.generic.GenericRegistry;
import io.enoa.docker.command.registry.origin.EDockerhubImpl;
import io.enoa.docker.command.registry.origin.EOriginRegistryImpl;
import io.enoa.docker.command.registry.origin.OriginRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EPMRegistry {
    private Map<String, OriginRegistry> origin = new ConcurrentHashMap<String, OriginRegistry>();
    private Map<String, GenericRegistry> generic = new ConcurrentHashMap<String, GenericRegistry>();
    private Map<String, EoRegistry> eo = new ConcurrentHashMap<String, EoRegistry>();
    private Map<String, AsyncRegistry> async = new ConcurrentHashMap<String, AsyncRegistry>();
    private Map<String, EAsyncOriginRegistry> asyncorigin;
    private Map<String, EAsyncGenericRegistry> asyncgeneric;
    private Map<String, EAsyncEnoaRegistry> asynceo = new ConcurrentHashMap<String, EAsyncEnoaRegistry>();

    static EPMRegistry instance() {
        return Holder.INSTANCE;
    }

    private EPMRegistry() {
        this.asyncorigin = new ConcurrentHashMap<String, EAsyncOriginRegistry>();
        this.asyncgeneric = new ConcurrentHashMap<String, EAsyncGenericRegistry>();
    }

    public void install(String name, RegistryConfig config) {
        if (config.dockerhub().booleanValue()) {
            this.origin.put(name, new EDockerhubImpl(config));
        } else {
            this.origin.put(name, new EOriginRegistryImpl(config));
        }
    }

    public void install(RegistryConfig config) {
        this.install("main", config);
    }

    public void uninstall(String name) {
        this.origin.remove(name);
        this.generic.remove(name);
        this.eo.remove(name);
    }

    public void uninstall() {
        this.uninstall("main");
    }

    OriginRegistry origin(String name) {
        OriginRegistry registry = this.origin.get(name);
        return registry;
    }

    OriginRegistry origin() {
        return this.origin("main");
    }

    GenericRegistry generic(String name) {
        GenericRegistry geneic = this.generic.get(name);
        if (geneic != null) {
            return geneic;
        }
        OriginRegistry origin = this.origin(name);
        if (origin == null) {
            return null;
        }
        geneic = new EGenericRegistryImpl(origin);
        this.generic.put(name, geneic);
        return geneic;
    }

    GenericRegistry generic() {
        return this.generic("main");
    }

    EoRegistry registry(String name) {
        EoRegistry registry = this.eo.get(name);
        if (registry != null) {
            return registry;
        }
        GenericRegistry generic = this.generic(name);
        if (generic == null) {
            return null;
        }
        registry = new EERegistryImpl(generic);
        this.eo.put(name, registry);
        return registry;
    }

    EoRegistry registry() {
        return this.registry("main");
    }

    AsyncRegistry async(String name) {
        AsyncRegistry registry = this.async.get(name);
        if (registry != null) {
            return registry;
        }
        registry = new AsyncRegistry(name);
        this.async.put(name, registry);
        return registry;
    }

    AsyncRegistry async() {
        return this.async("main");
    }

    EAsyncOriginRegistry asyncorigin(String name) {
        EAsyncOriginRegistry registry = this.asyncorigin.get(name);
        if (registry != null) {
            return registry;
        }
        registry = new EAsyncOriginRegistry(this.origin(name));
        this.asyncorigin.put(name, registry);
        return registry;
    }

    EAsyncGenericRegistry asyncgeneric(String name) {
        EAsyncGenericRegistry registry = this.asyncgeneric.get(name);
        if (registry != null) {
            return registry;
        }
        registry = new EAsyncGenericRegistry(this.generic(name));
        this.asyncgeneric.put(name, registry);
        return registry;
    }

    EAsyncEnoaRegistry asynceo(String name) {
        EAsyncEnoaRegistry registry = this.asynceo.get(name);
        if (registry != null) {
            return registry;
        }
        registry = new EAsyncEnoaRegistry(this.registry(name));
        this.asynceo.put(name, registry);
        return registry;
    }

    private static class Holder {
        private static final EPMRegistry INSTANCE = new EPMRegistry();

        private Holder() {
        }
    }
}

