/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker;

import io.enoa.docker.AsyncDockerhub;
import io.enoa.docker.DockerhubConfig;
import io.enoa.docker.async.hub.eo.EAsyncEnoaDockerhub;
import io.enoa.docker.async.hub.generic.EAsyncGenericDockerhub;
import io.enoa.docker.async.hub.origin.EAsyncOriginDockerhub;
import io.enoa.docker.command.hub.eo.EnoaDockerhub;
import io.enoa.docker.command.hub.generic.GenericDockerhub;
import io.enoa.docker.command.hub.origin.EOriginDockerhubImpl;
import io.enoa.docker.command.hub.origin.OriginDockerhub;

public class EPMDockerhub {
    private OriginDockerhub origin;
    private GenericDockerhub generic;
    private EnoaDockerhub eo;
    private AsyncDockerhub async;
    private EAsyncOriginDockerhub asyncorigin;
    private EAsyncGenericDockerhub asyncgeneric;
    private EAsyncEnoaDockerhub asynceo;

    static EPMDockerhub instance() {
        return Holder.INSTANCE;
    }

    private EPMDockerhub() {
    }

    public void install(DockerhubConfig config) {
        this.origin = new EOriginDockerhubImpl(config);
    }

    OriginDockerhub origin() {
        return this.origin;
    }

    GenericDockerhub generic() {
        if (this.generic != null) {
            return this.generic;
        }
        OriginDockerhub origin = this.origin();
        if (this.origin == null) {
            return null;
        }
        this.generic = new GenericDockerhub(origin);
        return this.generic;
    }

    EnoaDockerhub dockerhub() {
        if (this.eo != null) {
            return this.eo;
        }
        GenericDockerhub generic = this.generic();
        if (this.generic == null) {
            return null;
        }
        this.eo = new EnoaDockerhub(generic);
        return this.eo;
    }

    AsyncDockerhub async() {
        if (this.async != null) {
            return this.async;
        }
        this.async = new AsyncDockerhub();
        return this.async;
    }

    EAsyncOriginDockerhub asyncorigin() {
        if (this.asyncorigin != null) {
            return this.asyncorigin;
        }
        this.asyncorigin = new EAsyncOriginDockerhub(this.origin());
        return this.asyncorigin;
    }

    EAsyncGenericDockerhub asyncgeneric() {
        if (this.asyncgeneric != null) {
            return this.asyncgeneric;
        }
        this.asyncgeneric = new EAsyncGenericDockerhub(this.generic());
        return this.asyncgeneric;
    }

    EAsyncEnoaDockerhub asynceo() {
        if (this.asynceo != null) {
            return this.asynceo;
        }
        this.asynceo = new EAsyncEnoaDockerhub(this.dockerhub());
        return this.asynceo;
    }

    private static class Holder {
        private static final EPMDockerhub INSTANCE = new EPMDockerhub();

        private Holder() {
        }
    }
}

