/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.docker;

import io.enoa.docker.thr.DockerhubException;
import io.enoa.http.EoHttp;
import io.enoa.json.EnoaJson;
import io.enoa.json.EoJsonFactory;
import io.enoa.promise.Promise;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import java.util.concurrent.ExecutorService;

public class DockerhubConfig {
    private final String context;
    private final EoHttp http;
    private final EnoaJson json;
    private final ExecutorService executor;

    private DockerhubConfig(Builder builder) {
        this.json = builder.json.json();
        this.http = builder.http;
        this.context = builder.context;
        this.executor = builder.executor;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public String context() {
        return this.context;
    }

    public EoHttp http() {
        return this.http;
    }

    public EnoaJson json() {
        return this.json;
    }

    public static class Builder {
        private String context = "https://hub.docker.com/v2/";
        private EoJsonFactory json;
        private EoHttp http = EoHttp.def();
        private ExecutorService executor = Promise.builder().executor().enqueue("Dockerhub Dispatcher");

        public DockerhubConfig build() {
            if (this.json == null) {
                throw new DockerhubException(EnoaTipKit.message((String)"eo.tip.docker.no_json", (Object[])new Object[0]), new Object[0]);
            }
            return new DockerhubConfig(this);
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder json(EoJsonFactory json) {
            this.json = json;
            return this;
        }

        public Builder http(EoHttp http) {
            this.http = http;
            return this;
        }
    }
}

