/*
 * Copyright (c) 2018, enoa (fewensa@enoa.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.enoa.docker.dket.dockerhub.build;

import io.enoa.docker.dket.AbstractDRRet;

public class EHBuildTag extends AbstractDRRet {

  private final Integer id;
  private final String name;
  private final String dockerfilelocation;
  private final String sourcename;
  private final String sourcetype;

  public EHBuildTag(Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.dockerfilelocation = builder.dockerfilelocation;
    this.sourcename = builder.sourcename;
    this.sourcetype = builder.sourcetype;
  }

  public Integer id() {
    return this.id;
  }

  public String name() {
    return this.name;
  }

  public String dockerfilelocation() {
    return this.dockerfilelocation;
  }

  public String sourcename() {
    return this.sourcename;
  }

  public String sourcetype() {
    return this.sourcetype;
  }

  public static class Builder {
    private Integer id;
    private String name;
    private String dockerfilelocation;
    private String sourcename;
    private String sourcetype;

    public EHBuildTag build() {
      return new EHBuildTag(this);
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder dockerfilelocation(String dockerfilelocation) {
      this.dockerfilelocation = dockerfilelocation;
      return this;
    }

    public Builder sourcename(String sourcename) {
      this.sourcename = sourcename;
      return this;
    }

    public Builder sourcetype(String sourcetype) {
      this.sourcetype = sourcetype;
      return this;
    }
  }
}
