/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.db;

import io.enoa.db.EnoaDb;
import io.enoa.db.EoDbConfig;
import io.enoa.db.EoDbFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EPMDb {
    private static Map<String, EnoaDb> edbm = new ConcurrentHashMap<String, EnoaDb>();

    private static boolean exists(String name) {
        return edbm.keySet().stream().anyMatch(k -> k.equals(name));
    }

    public static void install(EoDbFactory db, EoDbConfig config) {
        if (EPMDb.exists(config.name())) {
            throw new RuntimeException("this db plugin name is exists. => " + config.name());
        }
        EnoaDb eodb = db.db(config);
        eodb.start();
        edbm.put(config.name(), eodb);
    }

    public static void uninstall(EoDbConfig config) {
        edbm.get(config.name()).stop();
    }
}

