/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.db.provider.db.mybatis.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Set;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.session.Configuration;

class _EnoaMapperRegistry
extends MapperRegistry {
    private final Configuration config;
    private final String location;
    private final String suffix;

    _EnoaMapperRegistry(Configuration config, String location, String suffix) {
        super(config);
        this.config = config;
        this.location = location;
        this.suffix = suffix;
    }

    public void addMappers(String packageName, Class<?> superType) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(superType), packageName);
        Set mapperSet = resolverUtil.getClasses();
        for (Class mapperClass : mapperSet) {
            this.addMapper(mapperClass);
        }
        File folder = new File(this.location);
        File[] files = folder.listFiles(file -> file.getAbsolutePath().endsWith(this.suffix));
        if (files == null || files.length == 0) {
            return;
        }
        for (File file2 : files) {
            FileInputStream stream;
            try {
                stream = new FileInputStream(file2);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            XMLMapperBuilder parser = new XMLMapperBuilder((InputStream)stream, this.config, file2.getAbsolutePath(), this.config.getSqlFragments());
            parser.parse();
        }
    }

    public void addMappers(String packageName) {
        this.addMappers(packageName, Object.class);
    }
}

