/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.db.provider.db.mybatis;

import io.enoa.db.provider.db.mybatis.MybatisSess;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSession;

public class MybatisKit {
    private static Map<String, MybatisSess> MANAGER_MAP = new ConcurrentHashMap<String, MybatisSess>();

    private MybatisKit() {
    }

    static void add(String name, SqlSession session) {
        Set<String> names = MANAGER_MAP.keySet();
        if (names.stream().anyMatch(k -> k.equals(name))) {
            throw new RuntimeException(String.format("Already exists this name: [%s] -> %s", String.join((CharSequence)", ", name), name));
        }
        MANAGER_MAP.put(name, new MybatisSess(session));
    }

    public static MybatisSess use(String name) {
        return MANAGER_MAP.get(name);
    }

    private static MybatisSess use() {
        return MybatisKit.use("main");
    }

    public static SqlSession session() {
        return MybatisKit.use().session();
    }

    public static <T> T with(Class<T> clazz) {
        return MybatisKit.use().with(clazz);
    }
}

