/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.provider.db.beetlsql;

import io.enoa.provider.db.beetlsql.BeetlSQLMgr;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DBRunner;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.OnConnection;
import org.beetl.sql.core.RowMapper;
import org.beetl.sql.core.SQLIdNameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLScript;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.engine.Beetl;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.core.kit.ConstantEnum;
import org.beetl.sql.core.mapper.MapperBuilder;
import org.beetl.sql.core.mapper.builder.MapperConfig;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.ext.gen.GenConfig;
import org.beetl.sql.ext.gen.GenFilter;

public class BeetlSQLKit {
    private static Map<String, BeetlSQLMgr> MANAGER_MAP = new ConcurrentHashMap<String, BeetlSQLMgr>();

    private BeetlSQLKit() {
    }

    static void add(String name, SQLManager manager) {
        Set<String> names = MANAGER_MAP.keySet();
        if (names.stream().anyMatch(k -> k.equals(name))) {
            throw new RuntimeException(String.format("Already exists this name: [%s] -> %s", String.join((CharSequence)", ", name), name));
        }
        MANAGER_MAP.put(name, new BeetlSQLMgr(manager));
    }

    private static BeetlSQLMgr use() {
        return BeetlSQLKit.use("main");
    }

    public static BeetlSQLMgr use(String name) {
        BeetlSQLMgr mgr = MANAGER_MAP.get(name);
        if (mgr == null) {
            throw new RuntimeException(String.format("This name is not exists. [%s] -> %s", String.join((CharSequence)", ", name), name));
        }
        return MANAGER_MAP.get(name);
    }

    public static SQLManager manager() {
        return BeetlSQLKit.use().manager();
    }

    public static <T> Query<T> query(Class<T> clazz) {
        return BeetlSQLKit.use().query(clazz);
    }

    public static boolean isOffsetStartZero() {
        return BeetlSQLKit.use().isOffsetStartZero();
    }

    public static boolean isProductMode() {
        return BeetlSQLKit.use().isProductMode();
    }

    public static SQLResult getSQLResult(String id, Map<String, Object> paras) {
        return BeetlSQLKit.use().getSQLResult(id, paras);
    }

    public static SQLResult getSQLResult(String id, Object paras) {
        return BeetlSQLKit.use().getSQLResult(id, paras);
    }

    public static SQLResult getSQLResult(SQLSource source, Map inputParas) {
        return BeetlSQLKit.use().getSQLResult(source, inputParas);
    }

    public static SQLResult getSQLResult(String id, Map<String, Object> paras, String parentId) {
        return BeetlSQLKit.use().getSQLResult(id, paras, parentId);
    }

    public static SQLScript getScript(String id) {
        return BeetlSQLKit.use().getScript(id);
    }

    public static SQLScript getScript(Class<?> cls, ConstantEnum constantEnum) {
        return BeetlSQLKit.use().getScript(cls, constantEnum);
    }

    public static SQLScript getPageSqlScript(String selectId) {
        return BeetlSQLKit.use().getPageSqlScript(selectId);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras, mapper);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Object paras) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz) {
        return BeetlSQLKit.use().select(sqlId, clazz);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Object paras, RowMapper<T> mapper) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras, mapper);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Object paras, long start, long size) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras, start, size);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Object paras, RowMapper<T> mapper, long start, long size) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras, mapper, start, size);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, long start, long size) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras, start, size);
    }

    public static <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper, long start, long size) {
        return BeetlSQLKit.use().select(sqlId, clazz, paras, mapper, start, size);
    }

    public static <T> PageQuery<T> pageQuery(String sqlId, Class<T> clazz, PageQuery<T> query) {
        return BeetlSQLKit.use().pageQuery(sqlId, clazz, query);
    }

    public static <T> PageQuery<T> pageQuery(String sqlId, Class<T> clazz, PageQuery query, RowMapper<T> mapper) {
        return BeetlSQLKit.use().pageQuery(sqlId, clazz, query, mapper);
    }

    public static <T> T unique(Class<T> clazz, Object pk) {
        return BeetlSQLKit.use().unique(clazz, pk);
    }

    public static <T> T unique(Class<T> clazz, RowMapper<T> mapper, Object pk) {
        return BeetlSQLKit.use().unique(clazz, mapper, pk);
    }

    public static <T> T single(Class<T> clazz, Object pk) {
        return BeetlSQLKit.use().single(clazz, pk);
    }

    public static <T> T lock(Class<T> clazz, Object pk) {
        return BeetlSQLKit.use().lock(clazz, pk);
    }

    public static <T> List<T> all(Class<T> clazz) {
        return BeetlSQLKit.use().all(clazz);
    }

    public static <T> List<T> all(Class<T> clazz, long start, long size) {
        return BeetlSQLKit.use().all(clazz, start, size);
    }

    public static long allCount(Class<?> clazz) {
        return BeetlSQLKit.use().allCount(clazz);
    }

    public static <T> List<T> all(Class<T> clazz, RowMapper<T> mapper, long start, int end) {
        return BeetlSQLKit.use().all(clazz, mapper, start, end);
    }

    public static <T> List<T> all(Class<T> clazz, RowMapper<T> mapper) {
        return BeetlSQLKit.use().all(clazz, mapper);
    }

    public static <T> List<T> template(T t) {
        return BeetlSQLKit.use().template(t);
    }

    public static <T> T templateOne(T t) {
        return BeetlSQLKit.use().templateOne(t);
    }

    public static <T> List<T> template(T t, RowMapper mapper) {
        return BeetlSQLKit.use().template(t, mapper);
    }

    public static <T> List<T> template(T t, long start, long size) {
        return BeetlSQLKit.use().template(t, start, size);
    }

    public static <T> List<T> template(Class<T> target, Object paras, long start, long size) {
        return BeetlSQLKit.use().template(target, paras, start, size);
    }

    public static <T> List<T> template(T t, RowMapper mapper, long start, long size) {
        return BeetlSQLKit.use().template(t, mapper, start, size);
    }

    public static <T> List<T> template(Class<T> target, Object paras, RowMapper mapper, long start, long size) {
        return BeetlSQLKit.use().template(target, paras, mapper, start, size);
    }

    public static <T> long templateCount(T t) {
        return BeetlSQLKit.use().templateCount(t);
    }

    public static <T> long templateCount(Class<T> target, Object paras) {
        return BeetlSQLKit.use().templateCount(target, paras);
    }

    public static Long longValue(String id, Map<String, Object> paras) {
        return BeetlSQLKit.use().longValue(id, paras);
    }

    public static Long longValue(String id, Object paras) {
        return BeetlSQLKit.use().longValue(id, paras);
    }

    public static Integer intValue(String id, Object paras) {
        return BeetlSQLKit.use().intValue(id, paras);
    }

    public static Integer intValue(String id, Map<String, Object> paras) {
        return BeetlSQLKit.use().intValue(id, paras);
    }

    public static BigDecimal bigDecimalValue(String id, Object paras) {
        return BeetlSQLKit.use().bigDecimalValue(id, paras);
    }

    public static BigDecimal bigDecimalValue(String id, Map<String, Object> paras) {
        return BeetlSQLKit.use().bigDecimalValue(id, paras);
    }

    public static <T> T selectSingle(String sqlId, Object paras, Class<T> target) {
        return BeetlSQLKit.use().selectSingle(sqlId, paras, target);
    }

    public static <T> T selectSingle(String sqlId, Map<String, Object> paras, Class<T> target) {
        return BeetlSQLKit.use().selectSingle(sqlId, paras, target);
    }

    public static <T> T selectUnique(String id, Object paras, Class<T> target) {
        return BeetlSQLKit.use().selectUnique(id, paras, target);
    }

    public static <T> T selectUnique(String id, Map<String, Object> paras, Class<T> target) {
        return BeetlSQLKit.use().selectUnique(id, paras, target);
    }

    public static int deleteById(Class<?> clazz, Object pkValue) {
        return BeetlSQLKit.use().deleteById(clazz, pkValue);
    }

    public static int deleteObject(Object obj) {
        return BeetlSQLKit.use().deleteObject(obj);
    }

    public static int insert(Object paras) {
        return BeetlSQLKit.use().insert(paras);
    }

    public static int insert(Object paras, boolean autoDbAssignKey) {
        return BeetlSQLKit.use().insert(paras, autoDbAssignKey);
    }

    public static int insertTemplate(Object paras) {
        return BeetlSQLKit.use().insertTemplate(paras);
    }

    public static int insertTemplate(Object paras, boolean autoDbAssignKey) {
        return BeetlSQLKit.use().insertTemplate(paras, autoDbAssignKey);
    }

    public static int insert(Class clazz, Object paras, boolean autoDbAssignKey) {
        return BeetlSQLKit.use().insert(clazz, paras, autoDbAssignKey);
    }

    public static int insertTemplate(Class clazz, Object paras, boolean autoDbAssignKey) {
        return BeetlSQLKit.use().insertTemplate(clazz, paras, autoDbAssignKey);
    }

    public static int insert(Class<?> clazz, Object paras) {
        return BeetlSQLKit.use().insert(clazz, paras);
    }

    public static int[] insertBatch(Class clazz, List<?> list) {
        return BeetlSQLKit.use().insertBatch(clazz, list);
    }

    public static int insert(Class<?> clazz, Object paras, KeyHolder holder) {
        return BeetlSQLKit.use().insert(clazz, paras, holder);
    }

    public static int insertTemplate(Class<?> clazz, Object paras, KeyHolder holder) {
        return BeetlSQLKit.use().insertTemplate(clazz, paras, holder);
    }

    public static int insert(String sqlId, Object paras, KeyHolder holder, String keyName) {
        return BeetlSQLKit.use().insert(sqlId, paras, holder, keyName);
    }

    public static int insert(String sqlId, Object paras, KeyHolder holder) {
        return BeetlSQLKit.use().insert(sqlId, paras, holder);
    }

    public static int insert(String sqlId, Class<?> clazz, Map paras, KeyHolder holder) {
        return BeetlSQLKit.use().insert(sqlId, clazz, paras, holder);
    }

    public static int insert(String sqlId, Map paras, KeyHolder holder, String keyName) {
        return BeetlSQLKit.use().insert(sqlId, paras, holder, keyName);
    }

    public static int updateById(Object obj) {
        return BeetlSQLKit.use().updateById(obj);
    }

    public static int updateTemplateById(Object obj) {
        return BeetlSQLKit.use().updateTemplateById(obj);
    }

    public static int updateTemplateById(Class c, Map paras) {
        return BeetlSQLKit.use().updateTemplateById(c, paras);
    }

    public static int updateTemplateById(Class c, Object obj) {
        return BeetlSQLKit.use().updateTemplateById(c, obj);
    }

    public static int[] updateByIdBatch(List<?> list) {
        return BeetlSQLKit.use().updateByIdBatch(list);
    }

    public static int update(String sqlId, Object obj) {
        return BeetlSQLKit.use().update(sqlId, obj);
    }

    public static int update(String sqlId) {
        return BeetlSQLKit.use().update(sqlId);
    }

    public static int update(String sqlId, Map<String, Object> paras) {
        return BeetlSQLKit.use().update(sqlId, paras);
    }

    public static int[] updateBatch(String sqlId, List<?> list) {
        return BeetlSQLKit.use().updateBatch(sqlId, list);
    }

    public static int[] updateBatchTemplateById(Class clz, List<?> list) {
        return BeetlSQLKit.use().updateBatchTemplateById(clz, list);
    }

    public static int[] updateBatch(String sqlId, Map<String, Object>[] maps) {
        return BeetlSQLKit.use().updateBatch(sqlId, maps);
    }

    public static int updateAll(Class<?> clazz, Object param) {
        return BeetlSQLKit.use().updateAll(clazz, param);
    }

    public static void useMaster(DBRunner f) {
        BeetlSQLKit.use().useMaster(f);
    }

    public static void useSlave(DBRunner f) {
        BeetlSQLKit.use().useSlave(f);
    }

    public static <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras) {
        return BeetlSQLKit.use().execute(sqlTemplate, clazz, paras);
    }

    public static <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras) {
        return BeetlSQLKit.use().execute(sqlTemplate, clazz, paras);
    }

    public static <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras, long start, long size) {
        return BeetlSQLKit.use().execute(sqlTemplate, clazz, paras, start, size);
    }

    public static <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras, long start, long size) {
        return BeetlSQLKit.use().execute(sqlTemplate, clazz, paras, start, size);
    }

    public static int executeUpdate(String sqlTemplate, Object paras) {
        return BeetlSQLKit.use().executeUpdate(sqlTemplate, paras);
    }

    public static int executeUpdate(String sqlTemplate, Map paras) {
        return BeetlSQLKit.use().executeUpdate(sqlTemplate, paras);
    }

    public static <T> List<T> execute(SQLReady p, Class<T> clazz) {
        return BeetlSQLKit.use().execute(p, clazz);
    }

    public static <T> PageQuery<T> execute(SQLReady p, Class<T> clazz, PageQuery<T> pageQuery) {
        return BeetlSQLKit.use().execute(p, clazz, pageQuery);
    }

    public static int executeUpdate(SQLReady p) {
        return BeetlSQLKit.use().executeUpdate(p);
    }

    public static <T> T executeOnConnection(OnConnection<T> onConnection) {
        return BeetlSQLKit.use().executeOnConnection(onConnection);
    }

    public static void genPojoCode(String table, String pkg, String srcPath, GenConfig config) throws Exception {
        BeetlSQLKit.use().genPojoCode(table, pkg, srcPath, config);
    }

    public static void genPojoCode(String table, String pkg, GenConfig config) throws Exception {
        BeetlSQLKit.use().genPojoCode(table, pkg, config);
    }

    public static void genPojoCode(String table, String pkg) throws Exception {
        BeetlSQLKit.use().genPojoCode(table, pkg);
    }

    public static void genPojoCodeToConsole(String table) throws Exception {
        BeetlSQLKit.use().genPojoCodeToConsole(table);
    }

    public static void genPojoCodeToConsole(String table, GenConfig config) throws Exception {
        BeetlSQLKit.use().genPojoCodeToConsole(table, config);
    }

    public static void genSQLFile(String table) throws Exception {
        BeetlSQLKit.use().genSQLFile(table);
    }

    public static void genSQLFile(String table, String alias) throws Exception {
        BeetlSQLKit.use().genSQLFile(table, alias);
    }

    public static void genSQLTemplateToConsole(String table) throws Exception {
        BeetlSQLKit.use().genSQLTemplateToConsole(table);
    }

    public static void genSQLTemplateToConsole(String table, String alias) throws Exception {
        BeetlSQLKit.use().genSQLTemplateToConsole(table, alias);
    }

    public static void genALL(String pkg, GenConfig config, GenFilter filter) throws Exception {
        BeetlSQLKit.use().genALL(pkg, config, filter);
    }

    public static void genBuiltInSqlToConsole(Class cls) {
        BeetlSQLKit.use().genBuiltInSqlToConsole(cls);
    }

    public static <T> T getMapper(Class<T> mapperInterface) {
        return BeetlSQLKit.use().getMapper(mapperInterface);
    }

    public static SQLLoader getSqlLoader() {
        return BeetlSQLKit.use().getSqlLoader();
    }

    public static void setSqlLoader(SQLLoader sqlLoader) {
        BeetlSQLKit.use().setSqlLoader(sqlLoader);
    }

    public static ConnectionSource getDs() {
        return BeetlSQLKit.use().getDs();
    }

    public static void setDs(ConnectionSource ds) {
        BeetlSQLKit.use().setDs(ds);
    }

    public static NameConversion getNc() {
        return BeetlSQLKit.use().getNc();
    }

    public static void setNc(NameConversion nc) {
        BeetlSQLKit.use().setNc(nc);
    }

    public static DBStyle getDbStyle() {
        return BeetlSQLKit.use().getDbStyle();
    }

    public static Beetl getBeetl() {
        return BeetlSQLKit.use().getBeetl();
    }

    public static MetadataManager getMetaDataManager() {
        return BeetlSQLKit.use().getMetaDataManager();
    }

    public static String getDefaultSchema() {
        return BeetlSQLKit.use().getDefaultSchema();
    }

    public static void setDefaultSchema(String defaultSchema) {
        BeetlSQLKit.use().setDefaultSchema(defaultSchema);
    }

    public static MapperBuilder getMapperBuilder() {
        return BeetlSQLKit.use().getMapperBuilder();
    }

    public static void setMapperBuilder(MapperBuilder mapperBuilder) {
        BeetlSQLKit.use().setMapperBuilder(mapperBuilder);
    }

    public static Interceptor[] getInters() {
        return BeetlSQLKit.use().getInters();
    }

    public static void setInters(Interceptor[] inters) {
        BeetlSQLKit.use().setInters(inters);
    }

    public static void addIdAutonGen(String name, IDAutoGen alorithm) {
        BeetlSQLKit.use().addIdAutonGen(name, alorithm);
    }

    public static Map<String, BeanProcessor> getProcessors() {
        return BeetlSQLKit.use().getProcessors();
    }

    public static void setProcessors(Map<String, BeanProcessor> processors) {
        BeetlSQLKit.use().setProcessors(processors);
    }

    public static BeanProcessor getDefaultBeanProcessors() {
        return BeetlSQLKit.use().getDefaultBeanProcessors();
    }

    public static void setDefaultBeanProcessors(BeanProcessor defaultBeanProcessors) {
        BeetlSQLKit.use().setDefaultBeanProcessors(defaultBeanProcessors);
    }

    public static void setSQLIdNameConversion(SQLIdNameConversion sqlIdNc) {
        BeetlSQLKit.use().setSQLIdNameConversion(sqlIdNc);
    }

    public static SQLIdNameConversion getSQLIdNameConversion() {
        return BeetlSQLKit.use().getSQLIdNameConversion();
    }

    public static MapperConfig getMapperConfig() {
        return BeetlSQLKit.use().getMapperConfig();
    }

    public static MapperConfig setBaseMapper(Class c) {
        return BeetlSQLKit.use().setBaseMapper(c);
    }

    public static String getSQLManagerName() {
        return BeetlSQLKit.use().getSQLManagerName();
    }
}

