/*
 * Decompiled with CFR 0.152.
 */
package io.enoa.provider.db.beetlsql;

import io.enoa.db.EoDbConfig;
import io.enoa.db.EoDsConfig;
import io.enoa.db.EoDsFactory;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;

public class BeetlSQLConfig
implements EoDbConfig {
    private final String name;
    private final EoDsFactory ds;
    private final EoDsConfig dsConfig;
    private final DBStyle style;
    private final String load;
    private final NameConversion nameConversion;
    private final Interceptor[] interceptors;

    private BeetlSQLConfig(Builder builder) {
        this.name = builder.name;
        this.ds = builder.ds;
        this.dsConfig = builder.dsConfig;
        this.style = builder.style;
        this.load = builder.load;
        this.nameConversion = builder.nameConversion;
        this.interceptors = builder.interceptors;
    }

    public String name() {
        return this.name;
    }

    public EoDsFactory ds() {
        return this.ds;
    }

    public EoDsConfig dsConfig() {
        return this.dsConfig;
    }

    public DBStyle style() {
        return this.style;
    }

    public String load() {
        return this.load;
    }

    public NameConversion nameConversion() {
        return this.nameConversion;
    }

    public Interceptor[] interceptors() {
        return this.interceptors;
    }

    public static class Builder {
        private String name = "main";
        private EoDsFactory ds;
        private EoDsConfig dsConfig;
        private DBStyle style;
        private String load = "/sql";
        private NameConversion nameConversion = new UnderlinedNameConversion();
        private Interceptor[] interceptors = new Interceptor[0];

        public BeetlSQLConfig build() {
            return new BeetlSQLConfig(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ds(EoDsFactory ds, EoDsConfig config) {
            this.ds = ds;
            this.dsConfig = config;
            return this;
        }

        public Builder style(DBStyle style) {
            this.style = style;
            return this;
        }

        public Builder load(String load) {
            this.load = load;
            return this;
        }

        public Builder nameConversion(NameConversion nameConversion) {
            this.nameConversion = nameConversion;
            return this;
        }

        public Builder interceptors(Interceptor[] interceptors) {
            this.interceptors = interceptors;
            return this;
        }
    }
}

