/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.reactnative;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.reactnative.RnSourcemapPathFinder;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\u0004J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/RnSourcemapPathFinder;", "", "reactProps", "", "", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "(Ljava/util/Map;Lio/embrace/android/gradle/swazzler/Logger;)V", "getBundleAssetName", "getBundleFile", "Lorg/gradle/api/provider/Provider;", "variantName", "projectTasks", "Lorg/gradle/api/tasks/TaskContainer;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "getCustomBundleAssetDirectory", "getDefaultBundleAssetDirectory", "taskContainer", "getEmbraceSourcemapFile", "getGeneratedAssetsFolders", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "getReactNativeSourcemapFile", "variantDirName", "getSourceMapJson", "variantData", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "logDeprecatedCommands", "", "embrace-bug-shake-gradle-plugin"})
public final class RnSourcemapPathFinder {
    private final Map<String, Object> reactProps;
    private final Logger<RnSourcemapPathFinder> logger;

    @NotNull
    public final String getReactNativeSourcemapFile(@NotNull String variantDirName) {
        Intrinsics.checkNotNullParameter((Object)variantDirName, (String)"variantDirName");
        String sourceMapsDirPath = "generated/sourcemaps/react/" + variantDirName;
        String bundleAssetName = this.getBundleAssetName(this.reactProps);
        return sourceMapsDirPath + '/' + bundleAssetName + ".map";
    }

    @NotNull
    public final String getEmbraceSourcemapFile() {
        this.logDeprecatedCommands();
        String sourceMapsDirPath = "generated/sourcemaps";
        this.logger.debug("Source map file path=" + sourceMapsDirPath);
        return sourceMapsDirPath + "/android-embrace.bundle.map";
    }

    private final void logDeprecatedCommands() {
        boolean bl;
        block6: {
            Map<String, Object> map2 = this.reactProps;
            Object object = map2 != null ? map2.get("extraPackagerArgs") : null;
            if (!(object instanceof List)) {
                object = null;
            }
            List list = (List)object;
            if (list == null) {
                return;
            }
            List extraPackagerArgValues = list;
            Iterable $this$any$iv = extraPackagerArgValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"--sourcemap-output", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            this.logger.warn("DEPRECATED: The command --sourcemap-output will be deprecated. Please remove that from your app/build.gradle extraPackagerArgs");
        }
    }

    @NotNull
    public final Provider<String> getBundleFile(@NotNull String variantName, @NotNull TaskContainer projectTasks, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)projectTasks, (String)"projectTasks");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        String capitalizedVariantName = StringUtils.capitalize((String)variantName);
        Provider provider2 = providerFactory.provider((Callable)new Callable<String>(this, capitalizedVariantName){
            final /* synthetic */ RnSourcemapPathFinder this$0;
            final /* synthetic */ String $capitalizedVariantName;

            @Nullable
            public final String call() {
                Map map2 = RnSourcemapPathFinder.access$getReactProps$p(this.this$0);
                String string = this.$capitalizedVariantName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalizedVariantName");
                return RnSourcemapPathFinder.access$getCustomBundleAssetDirectory(this.this$0, map2, string);
            }
            {
                this.this$0 = rnSourcemapPathFinder;
                this.$capitalizedVariantName = string;
            }
        });
        String string = capitalizedVariantName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalizedVariantName");
        Provider bundleAssetDirectoryProvider2 = provider2.orElse(this.getDefaultBundleAssetDirectory(string, projectTasks, providerFactory));
        String bundleAssetName = this.getBundleAssetName(this.reactProps);
        Provider provider3 = bundleAssetDirectoryProvider2;
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"bundleAssetDirectoryProvider");
        return GradleCompatibilityHelper.INSTANCE.map(provider3, providerFactory, (Transformer)new Transformer<String, String>(bundleAssetName){
            final /* synthetic */ String $bundleAssetName;

            @Nullable
            public final String transform(@Nullable String it) {
                CharSequence charSequence = it;
                boolean bl = false;
                boolean bl2 = false;
                return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? it + '/' + this.$bundleAssetName : this.$bundleAssetName;
            }
            {
                this.$bundleAssetName = string;
            }
        });
    }

    private final String getCustomBundleAssetDirectory(Map<String, ?> reactProps, String variantName) {
        String customBundleAssetDirectoryKey = "jsBundleDir" + variantName;
        this.logger.debug("Looking for custom bundle asset directory with key: " + customBundleAssetDirectoryKey);
        Map<String, ?> map2 = reactProps;
        if (map2 == null || (map2 = map2.get(customBundleAssetDirectoryKey)) == null || (map2 = map2.toString()) == null) {
            return null;
        }
        Map<String, ?> bundleAssetDirectory = map2;
        this.logger.debug("Custom bundle asset directory found: " + (String)((Object)bundleAssetDirectory));
        return bundleAssetDirectory;
    }

    private final Provider<String> getDefaultBundleAssetDirectory(String variantName, TaskContainer taskContainer, ProviderFactory providerFactory) {
        TaskProvider taskProvider2;
        String bundleJsAssetsName = "bundle" + variantName + "JsAndAssets";
        this.logger.debug("Custom bundle asset directory not found, looking for task: " + bundleJsAssetsName + '.');
        if (!taskContainer.getNames().contains(bundleJsAssetsName)) {
            Provider provider2 = providerFactory.provider((Callable)getDefaultBundleAssetDirectory.taskProvider.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.provider { \"\" }");
            return provider2;
        }
        TaskProvider taskProvider3 = taskProvider2 = taskContainer.named(bundleJsAssetsName);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"taskProvider");
        return this.getGeneratedAssetsFolders((TaskProvider<Task>)taskProvider3, providerFactory);
    }

    private final String getBundleAssetName(Map<String, ?> reactProps) {
        Map<String, ?> map2 = reactProps;
        if (map2 == null || (map2 = map2.get("bundleAssetName")) == null || (map2 = map2.toString()) == null) {
            map2 = "index.android.bundle";
        }
        return map2;
    }

    @NotNull
    public final String getSourceMapJson(@NotNull AndroidCompactedVariantData variantData) {
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        String flavorName = variantData.getFlavorName();
        String buildTypeName = variantData.getBuildTypeName();
        String bundleFileFolder = StringsKt.isBlank((CharSequence)flavorName) ? buildTypeName : flavorName + '/' + buildTypeName;
        return "outputs/embrace/" + bundleFileFolder + "/sourcemap.json";
    }

    private final Provider<String> getGeneratedAssetsFolders(TaskProvider<Task> taskProvider2, ProviderFactory providerFactory) {
        Provider provider2 = GradleCompatibilityHelper.INSTANCE.map((Provider)taskProvider2, providerFactory, getGeneratedAssetsFolders.1.INSTANCE).flatMap((Transformer)getGeneratedAssetsFolders.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"GradleCompatibilityHelpe\u2026\"\n            }\n        }");
        return provider2;
    }

    public RnSourcemapPathFinder(@Nullable Map<String, ? extends Object> reactProps, @NotNull Logger<RnSourcemapPathFinder> logger) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.reactProps = reactProps;
        this.logger = logger;
    }

    public /* synthetic */ RnSourcemapPathFinder(Map map2, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger<RnSourcemapPathFinder> logger2 = Logger.newLogger(RnSourcemapPathFinder.class);
            Intrinsics.checkNotNullExpressionValue(logger2, (String)"Logger.newLogger(RnSourc\u2026apPathFinder::class.java)");
            logger = logger2;
        }
        this(map2, logger);
    }

    public static final /* synthetic */ String access$getCustomBundleAssetDirectory(RnSourcemapPathFinder $this, Map reactProps, String variantName) {
        return $this.getCustomBundleAssetDirectory(reactProps, variantName);
    }

    public static final /* synthetic */ Map access$getReactProps$p(RnSourcemapPathFinder $this) {
        return $this.reactProps;
    }
}

