/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.oldtransform;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.compile.swazzler.Swazzler;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransform;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransformException;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransformer;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassPool;

@Deprecated
class IncrementalSwazzleTransformer
extends SwazzleTransformer {
    private static final Logger logger = Logger.newLogger(IncrementalSwazzleTransformer.class);

    IncrementalSwazzleTransformer(SwazzleTransform transform, ClassPool classPool, Swazzler swazzler, SwazzlerExtension swazzlerExtension, SmartSwazzlingManager smartSwazzlingManager, Boolean encodeExtractedFileNames) {
        super(transform, classPool, swazzler, swazzlerExtension, smartSwazzlingManager, encodeExtractedFileNames);
    }

    @Override
    void run(TransformInvocation invocation) throws Exception {
        super.run(invocation);
        logger.info("Swazzling all project input sources.");
        this.swazzleDirectoryInputs(invocation);
        this.swazzleJarInputs(invocation);
        logger.info("All project sources have been processed by the swazzler.");
    }

    @Override
    void swazzleDirectoryInput(TransformOutputProvider outputProvider, DirectoryInput dirInput) throws SwazzleTransformException {
        File destDir = Paths.get(this.getOutputFile(outputProvider, dirInput).getPath(), new String[0]).toFile();
        for (Map.Entry entry : dirInput.getChangedFiles().entrySet()) {
            boolean shouldCopyFile = false;
            File srcFile = (File)entry.getKey();
            final File destFile = Paths.get(destDir.getPath(), Paths.get(dirInput.getFile().getPath(), new String[0]).relativize(Paths.get(srcFile.getPath(), new String[0])).toString()).toFile();
            Status status = (Status)entry.getValue();
            try {
                switch (status) {
                    case ADDED: 
                    case CHANGED: {
                        if (srcFile.isFile() && FileUtils.isClassFile(srcFile.getName())) {
                            try {
                                logger.debug(String.format("Swazzling file from directory input {reason=%s, src=%s, dest=%s}.", status, srcFile, destFile));
                                shouldCopyFile = !this.swazzleExecutor.swazzleFile(srcFile, destDir);
                            }
                            catch (SwazzlerException e) {
                                logger.debug(String.format("An exception was thrown while swazzling file and will be ignored {src=%s, dest=%s}", srcFile, destFile), e);
                                shouldCopyFile = true;
                            }
                        } else {
                            shouldCopyFile = true;
                        }
                        if (!shouldCopyFile) break;
                        final Path srcDir = Paths.get(srcFile.getPath(), new String[0]);
                        Files.walkFileTree(srcDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                                Files.copy(path, Paths.get(destFile.getPath(), srcDir.relativize(path).toString()), StandardCopyOption.REPLACE_EXISTING);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                                Paths.get(destFile.getPath(), srcDir.relativize(path).toString()).toFile().mkdirs();
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        break;
                    }
                    case REMOVED: {
                        logger.debug(String.format("Removing file from directory input {reason=%s, file=%s}.", status, destFile.getPath()));
                        this.deleteDirectoryRecursion(Paths.get(destFile.getPath(), new String[0]));
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new SwazzleTransformException(String.format("An exception was thrown while swazzling the directory dependency {src=%s, dest=%s}.", srcFile, destDir), e);
            }
        }
    }

    private void deleteDirectoryRecursion(Path path) throws IOException {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                for (Path entry : entries) {
                    this.deleteDirectoryRecursion(entry);
                }
            }
        }
        Files.delete(path);
    }

    @Override
    public void swazzleJarInput(TransformOutputProvider outputProvider, JarInput jarInput) throws SwazzleTransformException {
        File jarFile = jarInput.getFile();
        Status status = jarInput.getStatus();
        Path destFile = Paths.get(this.getOutputFile(outputProvider, jarInput).getPath(), new String[0]);
        try {
            switch (status) {
                case NOTCHANGED: {
                    logger.debug(String.format("Copying/Replacing same JAR input {reason=%s, src=%s, dest=%s}.", status, jarFile, destFile));
                    Files.copy(Paths.get(jarFile.getPath(), new String[0]), destFile, StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    logger.debug(String.format("Swazzling JAR input {reason=%s, src=%s}.", status, jarFile));
                    super.swazzleJarInput(outputProvider, jarInput);
                    break;
                }
                case REMOVED: {
                    logger.debug(String.format("Removing JAR input {reason=%s, file=%s}.", status, jarFile));
                    Files.delete(destFile);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new SwazzleTransformException("An exception was thrown while swazzling the JAR dependency: " + jarFile, e);
        }
    }

    private void swazzleDirectoryInputs(TransformInvocation invocation) {
        logger.info("Swazzling all directory inputs.");
        long startTime = System.currentTimeMillis();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        List dirInputs = invocation.getInputs().stream().flatMap(input -> input.getDirectoryInputs().stream()).collect(Collectors.toList());
        for (DirectoryInput dirInput : dirInputs) {
            this.swazzleDirectoryInput(outputProvider, dirInput);
        }
        logger.info(String.format("Completed swazzling of all directory inputs in %dms.", System.currentTimeMillis() - startTime));
    }

    private void swazzleJarInputs(TransformInvocation invocation) {
        logger.info("Swazzling JAR inputs.");
        long startTime = System.currentTimeMillis();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        Stream<List<Object>> inputStream = invocation.getInputs().stream().flatMap(input -> input.getJarInputs().stream());
        if (!((Boolean)this.swazzlerExtension.getForceIncrementalOverwrite().get()).booleanValue()) {
            inputStream = inputStream.filter(input -> input.getStatus() != Status.NOTCHANGED);
        }
        List<JarInput> jarInputs = IncrementalSwazzleTransformer.dedupeJarInput(inputStream.collect(Collectors.toList()));
        logger.info(String.format("About to swazzle {%s} JARs.", jarInputs.size()));
        for (JarInput jarInput : jarInputs) {
            this.swazzleJarInput(outputProvider, jarInput);
        }
        logger.info(String.format("Completed Swazzling {%s} JARs in %dms.", jarInputs.size(), System.currentTimeMillis() - startTime));
        this.logJarsInDestinationFolder(jarInputs, outputProvider);
    }

    private void logJarsInDestinationFolder(List<JarInput> jarInputs, TransformOutputProvider outputProvider) {
        if (jarInputs.isEmpty()) {
            logger.debug("Empty JAR input list.");
            return;
        }
        JarInput firstJar = jarInputs.get(0);
        File[] jarList = new File(Paths.get(this.getOutputFile(outputProvider, firstJar).getPath(), new String[0]).getParent().toUri()).listFiles((dir, name) -> name.endsWith(".jar"));
        if (jarList == null) {
            logger.debug("Couldn't retrieve destination folder JAR list.");
            return;
        }
        logger.debug(String.format("{%d} JARs in dest directory: %s", jarList.length, Arrays.stream(jarList).sorted().map(File::getName).collect(Collectors.joining(", "))));
    }
}

