/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.ndk;

import com.android.build.gradle.api.ApplicationVariant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.TaskRegisterKt;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationUtilsKt;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporterExtension;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.ProvidedBuildReporter;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.ndk.NativeArchitectureFilesManager;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTask;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTaskRegistration;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTaskRegistration$WhenMappings;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLogger;
import io.embrace.android.gradle.swazzler.service.sentry.SentryLoggerExtension;
import io.embrace.android.gradle.swazzler.service.sentry.SentryVariantData;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.util.GradleUtils;
import io.embrace.android.gradle.swazzler.util.ProjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b0\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00000\u0000 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadTaskRegistration;", "Lorg/gradle/api/Action;", "Lcom/android/build/gradle/api/ApplicationVariant;", "project", "Lorg/gradle/api/Project;", "testCheckpoints", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "nativeArchitectureFilesManager", "Lio/embrace/android/gradle/swazzler/plugin/ndk/NativeArchitectureFilesManager;", "(Lorg/gradle/api/Project;Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;Lio/embrace/android/gradle/swazzler/plugin/ndk/NativeArchitectureFilesManager;)V", "buildReporter", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/ProvidedBuildReporter;", "kotlin.jvm.PlatformType", "embraceExtensionInternal", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "getProject", "()Lorg/gradle/api/Project;", "sentryLogger", "Lio/embrace/android/gradle/swazzler/service/sentry/SentryLogger;", "variantExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal$VariantExtension;", "configureDependenciesForNative", "", "ndkUploadTaskDependencies", "", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "execute", "variant", "getMappingFileFolder", "Lorg/gradle/api/provider/Provider;", "", "embrace-bug-shake-gradle-plugin"})
public final class NdkUploadTaskRegistration
implements Action<ApplicationVariant> {
    private final Logger<NdkUploadTaskRegistration> logger;
    private final SentryLogger sentryLogger;
    private final ProvidedBuildReporter buildReporter;
    private final EmbraceExtensionInternal embraceExtensionInternal;
    private EmbraceExtensionInternal.VariantExtension variantExtension;
    @NotNull
    private final Project project;
    private final SwazzlerTestCheckPoints testCheckpoints;
    private final NativeArchitectureFilesManager nativeArchitectureFilesManager;

    public void execute(@NotNull ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Object object = this.embraceExtensionInternal.getVariants().getByName(variant.getName());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"embraceExtensionInternal\u2026s.getByName(variant.name)");
        this.variantExtension = (EmbraceExtensionInternal.VariantExtension)object;
        StringBuilder stringBuilder = new StringBuilder().append("Starting to execute NdkUploadTaskRegistration for variant=");
        EmbraceExtensionInternal.VariantExtension variantExtension = this.variantExtension;
        if (variantExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
        }
        this.logger.debug(stringBuilder.append(variantExtension.getName()).toString());
        this.logger.debug("Ndk has been detected.");
        EmbraceExtensionInternal.VariantExtension variantExtension2 = this.variantExtension;
        if (variantExtension2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
        }
        if (TaskRegistrationUtilsKt.isTaskRegistered(this.project, "ndkUploadTask", variantExtension2.getName())) {
            StringBuilder stringBuilder2 = new StringBuilder().append("NDK symbols upload task found for variant ");
            EmbraceExtensionInternal.VariantExtension variantExtension3 = this.variantExtension;
            if (variantExtension3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
            }
            this.logger.debug(stringBuilder2.append(variantExtension3.getName()).append(" in the task graph. ").append("Skipping task registration.").toString());
            return;
        }
        try {
            TaskProvider<NdkUploadTask> ndkUploadTaskProvider2 = TaskRegisterKt.registerTask(this.project, "ndkUploadTask", NdkUploadTask.class, variant, (Provider<SentryVariantData>)((Provider)((EmbraceExtensionInternal.VariantExtension)this.embraceExtensionInternal.getVariants().getByName(variant.getName())).getSentryVariantData()), (Action)new Action<NdkUploadTask>(this, variant){
                final /* synthetic */ NdkUploadTaskRegistration this$0;
                final /* synthetic */ ApplicationVariant $variant;

                public final void execute(NdkUploadTask task) {
                    NdkUploadTask ndkUploadTask = task;
                    Intrinsics.checkNotNullExpressionValue((Object)ndkUploadTask, (String)"task");
                    ndkUploadTask.getApiToken().set((Provider)NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getApiToken());
                    Object object = NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getVariants().getByName(this.$variant.getName());
                    boolean bl = false;
                    boolean bl2 = false;
                    EmbraceExtensionInternal.VariantExtension variantExtension = (EmbraceExtensionInternal.VariantExtension)object;
                    boolean bl3 = false;
                    task.getAppId().set((Provider)variantExtension.getAppId());
                    task.getGeneratedEmbraceResourcesDirectory().set(variantExtension.getEmbraceBuildGeneratedResourcesPath().map((Transformer)execute.ndkUploadTaskProvider.1.1.INSTANCE));
                    task.getUrlSymbolUpload().set((Provider)NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getSymbolStoreHostUrl());
                    task.getUnitySymbolsDir().set((Provider)NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getUnitySymbolsDir());
                    task.getNdkEnabled().set((Provider)NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getNdkEnabled());
                    DirectoryProperty directoryProperty = task.getDeobfuscatedFilesDirPath();
                    ProjectLayout projectLayout = this.this$0.getProject().getLayout();
                    Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
                    directoryProperty.set(projectLayout.getBuildDirectory().dir(NdkUploadTaskRegistration.access$getMappingFileFolder(this.this$0).map((Transformer)execute.ndkUploadTaskProvider.2.INSTANCE)));
                    task.setArchitectureFilesForNative(NdkUploadTaskRegistration.access$getNativeArchitectureFilesManager$p(this.this$0).getNativeArchitectureFiles(this.$variant));
                }
                {
                    this.this$0 = ndkUploadTaskRegistration;
                    this.$variant = applicationVariant;
                }
            });
            this.logger.debug("Depends on successfully added");
            variant.registerGeneratedResFolders((FileCollection)this.project.getObjects().fileCollection().from(new Object[]{ndkUploadTaskProvider2.flatMap((Transformer)execute.1.INSTANCE)}));
            TaskContainer taskContainer = this.project.getTasks();
            this.logger.debug("Will attempt to configure task=" + ndkUploadTaskProvider2.getName());
            ndkUploadTaskProvider2.configure((Action)new Action<NdkUploadTask>(this, taskContainer){
                final /* synthetic */ NdkUploadTaskRegistration this$0;
                final /* synthetic */ TaskContainer $taskContainer;

                public final void execute(@NotNull NdkUploadTask ndkUploadTask) {
                    Intrinsics.checkNotNullParameter((Object)ndkUploadTask, (String)"ndkUploadTask");
                    NdkUploadTaskRegistration.access$getLogger$p(this.this$0).debug("Starting to configure NdkUploadTask");
                    Property<Boolean> ndkEnabled = NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getNdkEnabled();
                    ndkUploadTask.onlyIf((Spec)new Spec<Task>(ndkEnabled){
                        final /* synthetic */ Property $ndkEnabled;

                        public final boolean isSatisfiedBy(Task it) {
                            Object object = this.$ndkEnabled.getOrElse((Object)false);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ndkEnabled.getOrElse(false)");
                            return (Boolean)object;
                        }
                        {
                            this.$ndkEnabled = property;
                        }
                    });
                    ndkUploadTask.getNdkType().set(NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0).getProjectType().map((Transformer)new Transformer<NdkUploadTask.NdkType, ProjectType>(this){
                        final /* synthetic */ execute.2 this$0;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final NdkUploadTask.NdkType transform(ProjectType it) {
                            NdkUploadTask.NdkType ndkType;
                            ProjectType projectType = it;
                            if (projectType != null) {
                                switch (NdkUploadTaskRegistration$WhenMappings.$EnumSwitchMapping$0[projectType.ordinal()]) {
                                    case 1: {
                                        ndkType = NdkUploadTask.NdkType.UNITY;
                                        return ndkType;
                                    }
                                    case 2: {
                                        if (!NdkUploadTaskRegistration.access$getNativeArchitectureFilesManager$p(this.this$0.this$0).isCustomSymbolsDirectorySet()) {
                                            TaskContainer taskContainer = this.this$0.$taskContainer;
                                            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"taskContainer");
                                            if (!TaskRegistrationUtilsKt.isTaskRegistered(taskContainer, "externalNativeBuild", NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0.this$0).getName())) {
                                                ndkType = NdkUploadTask.NdkType.UNDEFINED;
                                                return ndkType;
                                            }
                                        }
                                        ndkType = NdkUploadTask.NdkType.NATIVE;
                                        return ndkType;
                                    }
                                }
                            }
                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("Failed to configure NDK upload task. Unknown NDK type.");
                            ndkType = NdkUploadTask.NdkType.UNDEFINED;
                            return ndkType;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                    ndkUploadTask.mustRunAfter(new Object[]{new Callable<Object>(this){
                        final /* synthetic */ execute.2 this$0;

                        /*
                         * Enabled aggressive block sorting
                         */
                        @NotNull
                        public Object call() {
                            boolean bl = false;
                            List ndkUploadTaskDependencies = new ArrayList<E>();
                            Object object = NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0.this$0).getNdkEnabled().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"embraceExtensionInternal.ndkEnabled.get()");
                            if ((Boolean)object == false) return ndkUploadTaskDependencies;
                            ProjectType projectType = (ProjectType)((Object)NdkUploadTaskRegistration.access$getEmbraceExtensionInternal$p(this.this$0.this$0).getProjectType().get());
                            if (projectType != null) {
                                switch (NdkUploadTaskRegistration$WhenMappings.$EnumSwitchMapping$1[projectType.ordinal()]) {
                                    case 1: {
                                        NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("Configuring ndk for unity");
                                        String mergeJniLibFoldersTaskName = "merge" + StringsKt.capitalize((String)NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0.this$0).getName()) + "JniLibFolders";
                                        TaskProvider<Task> mergeJniLibrariesTask = TaskRegistrationUtilsKt.tryGetTaskProvider(this.this$0.this$0.getProject(), mergeJniLibFoldersTaskName);
                                        if (mergeJniLibrariesTask != null) {
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + mergeJniLibFoldersTaskName + " successfully found");
                                        } else {
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + mergeJniLibFoldersTaskName + " not found");
                                        }
                                        String transformNativeLibsTaskName = "transformNativeLibsWithMergeJniLibsFor" + StringsKt.capitalize((String)NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0.this$0).getName());
                                        TaskProvider<Task> transformJniLibrariesTask = TaskRegistrationUtilsKt.tryGetTaskProvider(this.this$0.this$0.getProject(), transformNativeLibsTaskName);
                                        if (transformJniLibrariesTask != null) {
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + transformNativeLibsTaskName + " successfully found");
                                        } else {
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + transformNativeLibsTaskName + " not found");
                                        }
                                        String mergeNativeLibs = "merge" + StringsKt.capitalize((String)NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0.this$0).getName()) + "NativeLibs";
                                        TaskProvider<Task> mergeNativeLibsTask = TaskRegistrationUtilsKt.tryGetTaskProvider(this.this$0.this$0.getProject(), mergeNativeLibs);
                                        if (mergeNativeLibsTask != null) {
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + mergeNativeLibs + " successfully found");
                                        } else {
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + mergeNativeLibs + " not found");
                                        }
                                        if (TaskRegistrationUtilsKt.isTaskRegistered(mergeJniLibrariesTask)) {
                                            TaskProvider<Task> taskProvider2 = mergeJniLibrariesTask;
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + (taskProvider2 != null ? taskProvider2.getName() : null) + " is registered");
                                            if (TaskRegistrationUtilsKt.isTaskRegistered(transformJniLibrariesTask)) {
                                                TaskProvider<Task> taskProvider3 = transformJniLibrariesTask;
                                                NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + (taskProvider3 != null ? taskProvider3.getName() : null) + " is registered");
                                                NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("NdkUploadTask must run after mergeJniLibrariesTask");
                                                ndkUploadTaskDependencies.add(mergeJniLibrariesTask);
                                                NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("Successfully set NdkUploadTask to run after mergeJniLibrariesTask");
                                                return ndkUploadTaskDependencies;
                                            }
                                            if (TaskRegistrationUtilsKt.isTaskRegistered(mergeNativeLibsTask)) {
                                                TaskProvider<Task> taskProvider4 = mergeNativeLibsTask;
                                                NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + (taskProvider4 != null ? taskProvider4.getName() : null) + " is registered");
                                                NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("NdkUploadTask must run after mergeNativeLibsTask");
                                                ndkUploadTaskDependencies.add(mergeNativeLibsTask);
                                                NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("Successfully set NdkUploadTask to run after mergeNativeLibsTask");
                                                return ndkUploadTaskDependencies;
                                            }
                                            TaskProvider<Task> taskProvider5 = transformJniLibrariesTask;
                                            TaskProvider<Task> taskProvider6 = mergeNativeLibsTask;
                                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("Neither task=" + (taskProvider5 != null ? taskProvider5.getName() : null) + " and " + "task=" + (taskProvider6 != null ? taskProvider6.getName() : null) + " are registered.");
                                            return ndkUploadTaskDependencies;
                                        }
                                        TaskProvider<Task> taskProvider7 = mergeJniLibrariesTask;
                                        NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("task=" + (taskProvider7 != null ? taskProvider7.getName() : null) + " is not registered");
                                        return ndkUploadTaskDependencies;
                                    }
                                    case 2: {
                                        if (NdkUploadTaskRegistration.access$getNativeArchitectureFilesManager$p(this.this$0.this$0).isCustomSymbolsDirectorySet()) return ndkUploadTaskDependencies;
                                        NdkUploadTaskRegistration.access$configureDependenciesForNative(this.this$0.this$0, ndkUploadTaskDependencies);
                                        return ndkUploadTaskDependencies;
                                    }
                                }
                            }
                            NdkUploadTaskRegistration.access$getLogger$p(this.this$0.this$0).debug("Failed to configure NDK upload task. Unknown NDK type.");
                            return ndkUploadTaskDependencies;
                        }
                        {
                            this.this$0 = this$0;
                        }
                    }});
                }
                {
                    this.this$0 = ndkUploadTaskRegistration;
                    this.$taskContainer = taskContainer;
                }
            });
        }
        catch (Exception e) {
            StringBuilder stringBuilder3 = new StringBuilder().append("Error while registering NdkUploadTask for variant=");
            EmbraceExtensionInternal.VariantExtension variantExtension4 = this.variantExtension;
            if (variantExtension4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
            }
            this.logger.error(stringBuilder3.append(variantExtension4.getName()).append('.').toString(), e);
            this.testCheckpoints.exception(e);
            this.sentryLogger.sendException(e);
            this.buildReporter.onException(e);
            throw (Throwable)e;
        }
    }

    private final void configureDependenciesForNative(List<TaskProvider<Task>> ndkUploadTaskDependencies) {
        String externalNativeBuildTaskName;
        TaskProvider<Task> externalNativeBuildTask;
        this.logger.debug("Configuring ndk for native");
        StringBuilder stringBuilder = new StringBuilder().append("externalNativeBuild");
        EmbraceExtensionInternal.VariantExtension variantExtension = this.variantExtension;
        if (variantExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
        }
        if ((externalNativeBuildTask = TaskRegistrationUtilsKt.tryGetTaskProvider(this.project, externalNativeBuildTaskName = stringBuilder.append(StringsKt.capitalize((String)variantExtension.getName())).toString())) != null) {
            this.logger.debug("task=" + externalNativeBuildTaskName + " successfully found");
        } else {
            this.logger.debug("task=" + externalNativeBuildTaskName + " not found");
        }
        if (TaskRegistrationUtilsKt.isTaskRegistered(externalNativeBuildTask)) {
            this.logger.debug("Task=" + externalNativeBuildTaskName + " is registered");
            this.logger.debug("NdkUploadTask must run after externalNativeBuildTask");
            ndkUploadTaskDependencies.add(externalNativeBuildTask);
            this.logger.debug("Successfully set NdkUploadTask to run after " + externalNativeBuildTaskName);
        } else {
            this.logger.debug("task=" + externalNativeBuildTaskName + " is not registered");
        }
    }

    private final Provider<String> getMappingFileFolder() {
        Supplier supplier = new Supplier<ListProperty<Object>>(this){
            final /* synthetic */ NdkUploadTaskRegistration this$0;

            public final ListProperty<Object> get() {
                return this.this$0.getProject().getObjects().listProperty(Object.class);
            }
            {
                this.this$0 = ndkUploadTaskRegistration;
            }
        };
        EmbraceExtensionInternal.VariantExtension variantExtension = this.variantExtension;
        if (variantExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
        }
        Provider provider2 = variantExtension.getFlavorName().orElse(this.project.provider((Callable)getMappingFileFolder.2.INSTANCE));
        EmbraceExtensionInternal.VariantExtension variantExtension2 = this.variantExtension;
        if (variantExtension2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
        }
        Provider provider3 = GradleUtils.zip(supplier, provider2, (Provider)variantExtension2.getBuildTypeName(), getMappingFileFolder.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(provider3, (String)"GradleUtils.zip(\n       \u2026}\n            }\n        )");
        return provider3;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public NdkUploadTaskRegistration(@NotNull Project project, @NotNull SwazzlerTestCheckPoints testCheckpoints, @NotNull NativeArchitectureFilesManager nativeArchitectureFilesManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testCheckpoints, (String)"testCheckpoints");
        Intrinsics.checkNotNullParameter((Object)nativeArchitectureFilesManager, (String)"nativeArchitectureFilesManager");
        this.project = project;
        this.testCheckpoints = testCheckpoints;
        this.nativeArchitectureFilesManager = nativeArchitectureFilesManager;
        this.logger = Logger.newLogger(NdkUploadTaskRegistration.class);
        this.sentryLogger = (SentryLogger)((SentryLoggerExtension)this.project.getExtensions().getByType(SentryLoggerExtension.class)).getSentryLogger().get();
        this.buildReporter = (ProvidedBuildReporter)((BuildReporterExtension)this.project.getExtensions().getByType(BuildReporterExtension.class)).getBuildReporter().get();
        Object object = this.project.getExtensions().getByType(EmbraceExtensionInternal.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026nal::class.java\n        )");
        this.embraceExtensionInternal = (EmbraceExtensionInternal)object;
    }

    public static final /* synthetic */ EmbraceExtensionInternal access$getEmbraceExtensionInternal$p(NdkUploadTaskRegistration $this) {
        return $this.embraceExtensionInternal;
    }

    public static final /* synthetic */ Provider access$getMappingFileFolder(NdkUploadTaskRegistration $this) {
        return $this.getMappingFileFolder();
    }

    public static final /* synthetic */ NativeArchitectureFilesManager access$getNativeArchitectureFilesManager$p(NdkUploadTaskRegistration $this) {
        return $this.nativeArchitectureFilesManager;
    }

    public static final /* synthetic */ Logger access$getLogger$p(NdkUploadTaskRegistration $this) {
        return $this.logger;
    }

    public static final /* synthetic */ EmbraceExtensionInternal.VariantExtension access$getVariantExtension$p(NdkUploadTaskRegistration $this) {
        EmbraceExtensionInternal.VariantExtension variantExtension = $this.variantExtension;
        if (variantExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
        }
        return variantExtension;
    }

    public static final /* synthetic */ void access$setVariantExtension$p(NdkUploadTaskRegistration $this, EmbraceExtensionInternal.VariantExtension variantExtension) {
        $this.variantExtension = variantExtension;
    }

    public static final /* synthetic */ void access$configureDependenciesForNative(NdkUploadTaskRegistration $this, List ndkUploadTaskDependencies) {
        $this.configureDependenciesForNative(ndkUploadTaskDependencies);
    }
}

